/*-
 * Copyright 2018 Vsevolod Stakhov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef RSPAMD_HTML_ENTITIES_H
#define RSPAMD_HTML_ENTITIES_H

struct _entity;
typedef struct _entity entity;

struct _entity {
	gchar *name;
	uint code;
	gchar *replacement;
};

static entity entities_defs[] = {
		{"szlig", 223, "\xc3\x9f"},
		{"prime", 8242, "\xe2\x80\xb2"},
		{"lnsim", 8934, "\xe2\x8b\xa6"},
		{"nvDash", 8877, "\xe2\x8a\xad"},
		{"isinsv", 8947, "\xe2\x8b\xb3"},
		{"notin", 8713, "\xe2\x88\x89"},
		{"becaus", 8757, "\xe2\x88\xb5"},
		{"Leftrightarrow", 8660, "\xe2\x87\x94"},
		{"EmptySmallSquare", 9723, "\xe2\x97\xbb"},
		{"SquareUnion", 8852, "\xe2\x8a\x94"},
		{"subdot", 10941, "\xe2\xaa\xbd"},
		{"Dstrok", 272, "\xc4\x90"},
		{"rrarr", 8649, "\xe2\x87\x89"},
		{"rArr", 8658, "\xe2\x87\x92"},
		{"Aacute", 193, "\xc3\x81"},
		{"kappa", 954, "\xce\xba"},
		{"Iopf", 120128, "\xf0\x9d\x95\x80"},
		{"hyphen", 8208, "\xe2\x80\x90"},
		{"rarrbfs", 10528, "\xe2\xa4\xa0"},
		{"supsetneqq", 10956, "\xe2\xab\x8c"},
		{"gacute", 501, "\xc7\xb5"},
		{"VeryThinSpace", 8202, "\xe2\x80\x8a"},
		{"tint", 8749, "\xe2\x88\xad"},
		{"ffr", 120099, "\xf0\x9d\x94\xa3"},
		{"kgreen", 312, "\xc4\xb8"},
		{"nis", 8956, "\xe2\x8b\xbc"},
		{"NotRightTriangleBar", 10704, "\xe2\xa7\x90\xcc\xb8"},
		{"Eogon", 280, "\xc4\x98"},
		{"lbrke", 10635, "\xe2\xa6\x8b"},
		{"phi", 966, "\xcf\x86"},
		{"notnivc", 8957, "\xe2\x8b\xbd"},
		{"utilde", 361, "\xc5\xa9"},
		{"Fopf", 120125, "\xf0\x9d\x94\xbd"},
		{"Vcy", 1042, "\xd0\x92"},
		{"erDot", 8787, "\xe2\x89\x93"},
		{"nsubE", 10949, "\xe2\xab\x85\xcc\xb8"},
		{"egrave", 232, "\xc3\xa8"},
		{"Lcedil", 315, "\xc4\xbb"},
		{"lharul", 10602, "\xe2\xa5\xaa"},
		{"middot", 183, "\xc2\xb7"},
		{"ggg", 8921, "\xe2\x8b\x99"},
		{"NestedLessLess", 8810, "\xe2\x89\xaa"},
		{"tau", 964, "\xcf\x84"},
		{"setmn", 8726, "\xe2\x88\x96"},
		{"frac78", 8542, "\xe2\x85\x9e"},
		{"para", 182, "\xc2\xb6"},
		{"Rcedil", 342, "\xc5\x96"},
		{"propto", 8733, "\xe2\x88\x9d"},
		{"sqsubset", 8847, "\xe2\x8a\x8f"},
		{"ensp", 8194, "\xe2\x80\x82"},
		{"boxvH", 9578, "\xe2\x95\xaa"},
		{"NotGreaterTilde", 8821, "\xe2\x89\xb5"},
		{"ffllig", 64260, "\xef\xac\x84"},
		{"kcedil", 311, "\xc4\xb7"},
		{"omega", 969, "\xcf\x89"},
		{"sime", 8771, "\xe2\x89\x83"},
		{"LeftTriangleEqual", 8884, "\xe2\x8a\xb4"},
		{"bsemi", 8271, "\xe2\x81\x8f"},
		{"rdquor", 8221, "\xe2\x80\x9d"},
		{"Utilde", 360, "\xc5\xa8"},
		{"bsol", 92, "\x5c"},
		{"risingdotseq", 8787, "\xe2\x89\x93"},
		{"ultri", 9720, "\xe2\x97\xb8"},
		{"rhov", 1009, "\xcf\xb1"},
		{"TildeEqual", 8771, "\xe2\x89\x83"},
		{"jukcy", 1108, "\xd1\x94"},
		{"perp", 8869, "\xe2\x8a\xa5"},
		{"capbrcup", 10825, "\xe2\xa9\x89"},
		{"ltrie", 8884, "\xe2\x8a\xb4"},
		{"LessTilde", 8818, "\xe2\x89\xb2"},
		{"popf", 120161, "\xf0\x9d\x95\xa1"},
		{"dbkarow", 10511, "\xe2\xa4\x8f"},
		{"roang", 10221, "\xe2\x9f\xad"},
		{"brvbar", 166, "\xc2\xa6"},
		{"CenterDot", 183, "\xc2\xb7"},
		{"notindot", 8949, "\xe2\x8b\xb5\xcc\xb8"},
		{"supmult", 10946, "\xe2\xab\x82"},
		{"multimap", 8888, "\xe2\x8a\xb8"},
		{"frac34", 190, "\xc2\xbe"},
		{"mapsto", 8614, "\xe2\x86\xa6"},
		{"flat", 9837, "\xe2\x99\xad"},
		{"updownarrow", 8597, "\xe2\x86\x95"},
		{"gne", 10888, "\xe2\xaa\x88"},
		{"nrarrc", 10547, "\xe2\xa4\xb3\xcc\xb8"},
		{"suphsol", 10185, "\xe2\x9f\x89"},
		{"nGtv", 8811, "\xe2\x89\xab\xcc\xb8"},
		{"hopf", 120153, "\xf0\x9d\x95\x99"},
		{"pointint", 10773, "\xe2\xa8\x95"},
		{"glj", 10916, "\xe2\xaa\xa4"},
		{"LeftDoubleBracket", 10214, "\xe2\x9f\xa6"},
		{"NotSupersetEqual", 8841, "\xe2\x8a\x89"},
		{"dot", 729, "\xcb\x99"},
		{"tbrk", 9140, "\xe2\x8e\xb4"},
		{"LeftUpDownVector", 10577, "\xe2\xa5\x91"},
		{"uml", 168, "\xc2\xa8"},
		{"bbrk", 9141, "\xe2\x8e\xb5"},
		{"nearrow", 8599, "\xe2\x86\x97"},
		{"backsimeq", 8909, "\xe2\x8b\x8d"},
		{"dblac", 733, "\xcb\x9d"},
		{"circleddash", 8861, "\xe2\x8a\x9d"},
		{"ldsh", 8626, "\xe2\x86\xb2"},
		{"sce", 10928, "\xe2\xaa\xb0"},
		{"angst", 197, "\xc3\x85"},
		{"yen", 165, "\xc2\xa5"},
		{"nsupE", 10950, "\xe2\xab\x86\xcc\xb8"},
		{"Uscr", 119984, "\xf0\x9d\x92\xb0"},
		{"subplus", 10943, "\xe2\xaa\xbf"},
		{"nleqq", 8806, "\xe2\x89\xa6\xcc\xb8"},
		{"nprcue", 8928, "\xe2\x8b\xa0"},
		{"Ocirc", 212, "\xc3\x94"},
		{"disin", 8946, "\xe2\x8b\xb2"},
		{"EqualTilde", 8770, "\xe2\x89\x82"},
		{"YUcy", 1070, "\xd0\xae"},
		{"Kscr", 119974, "\xf0\x9d\x92\xa6"},
		{"lg", 8822, "\xe2\x89\xb6"},
		{"nLeftrightarrow", 8654, "\xe2\x87\x8e"},
		{"eplus", 10865, "\xe2\xa9\xb1"},
		{"les", 10877, "\xe2\xa9\xbd"},
		{"sfr", 120112, "\xf0\x9d\x94\xb0"},
		{"HumpDownHump", 8782, "\xe2\x89\x8e"},
		{"Fouriertrf", 8497, "\xe2\x84\xb1"},
		{"Updownarrow", 8661, "\xe2\x87\x95"},
		{"nrarr", 8603, "\xe2\x86\x9b"},
		{"radic", 8730, "\xe2\x88\x9a"},
		{"gnap", 10890, "\xe2\xaa\x8a"},
		{"zeta", 950, "\xce\xb6"},
		{"Qscr", 119980, "\xf0\x9d\x92\xac"},
		{"NotRightTriangleEqual", 8941, "\xe2\x8b\xad"},
		{"nshortmid", 8740, "\xe2\x88\xa4"},
		{"SHCHcy", 1065, "\xd0\xa9"},
		{"piv", 982, "\xcf\x96"},
		{"angmsdaa", 10664, "\xe2\xa6\xa8"},
		{"curlywedge", 8911, "\xe2\x8b\x8f"},
		{"sqcaps", 8851, "\xe2\x8a\x93\xef\xb8\x80"},
		{"sum", 8721, "\xe2\x88\x91"},
		{"rarrtl", 8611, "\xe2\x86\xa3"},
		{"gescc", 10921, "\xe2\xaa\xa9"},
		{"sup", 8835, "\xe2\x8a\x83"},
		{"smid", 8739, "\xe2\x88\xa3"},
		{"cularr", 8630, "\xe2\x86\xb6"},
		{"olcross", 10683, "\xe2\xa6\xbb"},
		{"GT", 62, "\x3e"},
		{"scap", 10936, "\xe2\xaa\xb8"},
		{"capcup", 10823, "\xe2\xa9\x87"},
		{"NotSquareSubsetEqual", 8930, "\xe2\x8b\xa2"},
		{"uhblk", 9600, "\xe2\x96\x80"},
		{"latail", 10521, "\xe2\xa4\x99"},
		{"smtes", 10924, "\xe2\xaa\xac\xef\xb8\x80"},
		{"RoundImplies", 10608, "\xe2\xa5\xb0"},
		{"wreath", 8768, "\xe2\x89\x80"},
		{"curlyvee", 8910, "\xe2\x8b\x8e"},
		{"uscr", 120010, "\xf0\x9d\x93\x8a"},
		{"nleftrightarrow", 8622, "\xe2\x86\xae"},
		{"ucy", 1091, "\xd1\x83"},
		{"nvge", 8805, "\xe2\x89\xa5\xe2\x83\x92"},
		{"bnot", 8976, "\xe2\x8c\x90"},
		{"alefsym", 8501, "\xe2\x84\xb5"},
		{"star", 9734, "\xe2\x98\x86"},
		{"boxHd", 9572, "\xe2\x95\xa4"},
		{"vsubnE", 10955, "\xe2\xab\x8b\xef\xb8\x80"},
		{"Popf", 8473, "\xe2\x84\x99"},
		{"simgE", 10912, "\xe2\xaa\xa0"},
		{"upsilon", 965, "\xcf\x85"},
		{"NoBreak", 8288, "\xe2\x81\xa0"},
		{"realine", 8475, "\xe2\x84\x9b"},
		{"frac38", 8540, "\xe2\x85\x9c"},
		{"YAcy", 1071, "\xd0\xaf"},
		{"bnequiv", 8801, "\xe2\x89\xa1\xe2\x83\xa5"},
		{"cudarrr", 10549, "\xe2\xa4\xb5"},
		{"lsime", 10893, "\xe2\xaa\x8d"},
		{"lowbar", 95, "\x5f"},
		{"utdot", 8944, "\xe2\x8b\xb0"},
		{"ReverseElement", 8715, "\xe2\x88\x8b"},
		{"nshortparallel", 8742, "\xe2\x88\xa6"},
		{"DJcy", 1026, "\xd0\x82"},
		{"nsube", 8840, "\xe2\x8a\x88"},
		{"VDash", 8875, "\xe2\x8a\xab"},
		{"Ncaron", 327, "\xc5\x87"},
		{"LeftUpVector", 8639, "\xe2\x86\xbf"},
		{"Kcy", 1050, "\xd0\x9a"},
		{"NotLeftTriangleEqual", 8940, "\xe2\x8b\xac"},
		{"nvHarr", 10500, "\xe2\xa4\x84"},
		{"lotimes", 10804, "\xe2\xa8\xb4"},
		{"RightFloor", 8971, "\xe2\x8c\x8b"},
		{"succ", 8827, "\xe2\x89\xbb"},
		{"Ucy", 1059, "\xd0\xa3"},
		{"darr", 8595, "\xe2\x86\x93"},
		{"lbarr", 10508, "\xe2\xa4\x8c"},
		{"xfr", 120117, "\xf0\x9d\x94\xb5"},
		{"zopf", 120171, "\xf0\x9d\x95\xab"},
		{"Phi", 934, "\xce\xa6"},
		{"ord", 10845, "\xe2\xa9\x9d"},
		{"iinfin", 10716, "\xe2\xa7\x9c"},
		{"Xfr", 120091, "\xf0\x9d\x94\x9b"},
		{"qint", 10764, "\xe2\xa8\x8c"},
		{"Upsilon", 933, "\xce\xa5"},
		{"NotSubset", 8834, "\xe2\x8a\x82\xe2\x83\x92"},
		{"gfr", 120100, "\xf0\x9d\x94\xa4"},
		{"notnivb", 8958, "\xe2\x8b\xbe"},
		{"Afr", 120068, "\xf0\x9d\x94\x84"},
		{"ge", 8805, "\xe2\x89\xa5"},
		{"iexcl", 161, "\xc2\xa1"},
		{"dfr", 120097, "\xf0\x9d\x94\xa1"},
		{"rsaquo", 8250, "\xe2\x80\xba"},
		{"xcap", 8898, "\xe2\x8b\x82"},
		{"Jopf", 120129, "\xf0\x9d\x95\x81"},
		{"Hstrok", 294, "\xc4\xa6"},
		{"ldca", 10550, "\xe2\xa4\xb6"},
		{"lmoust", 9136, "\xe2\x8e\xb0"},
		{"wcirc", 373, "\xc5\xb5"},
		{"DownRightVector", 8641, "\xe2\x87\x81"},
		{"LessFullEqual", 8806, "\xe2\x89\xa6"},
		{"dotsquare", 8865, "\xe2\x8a\xa1"},
		{"zhcy", 1078, "\xd0\xb6"},
		{"mDDot", 8762, "\xe2\x88\xba"},
		{"Prime", 8243, "\xe2\x80\xb3"},
		{"prec", 8826, "\xe2\x89\xba"},
		{"swnwar", 10538, "\xe2\xa4\xaa"},
		{"COPY", 169, "\xc2\xa9"},
		{"cong", 8773, "\xe2\x89\x85"},
		{"sacute", 347, "\xc5\x9b"},
		{"Nopf", 8469, "\xe2\x84\x95"},
		{"it", 8290, "\xe2\x81\xa2"},
		{"SOFTcy", 1068, "\xd0\xac"},
		{"uuarr", 8648, "\xe2\x87\x88"},
		{"iota", 953, "\xce\xb9"},
		{"notinE", 8953, "\xe2\x8b\xb9\xcc\xb8"},
		{"jfr", 120103, "\xf0\x9d\x94\xa7"},
		{"QUOT", 34, "\x22"},
		{"vsupnE", 10956, "\xe2\xab\x8c\xef\xb8\x80"},
		{"igrave", 236, "\xc3\xac"},
		{"bsim", 8765, "\xe2\x88\xbd"},
		{"npreceq", 10927, "\xe2\xaa\xaf\xcc\xb8"},
		{"zcaron", 382, "\xc5\xbe"},
		{"DD", 8517, "\xe2\x85\x85"},
		{"gamma", 947, "\xce\xb3"},
		{"homtht", 8763, "\xe2\x88\xbb"},
		{"NonBreakingSpace", 160, "\xc2\xa0"},
		{"Proportion", 8759, "\xe2\x88\xb7"},
		{"nedot", 8784, "\xe2\x89\x90\xcc\xb8"},
		{"nabla", 8711, "\xe2\x88\x87"},
		{"ac", 8766, "\xe2\x88\xbe"},
		{"nsupe", 8841, "\xe2\x8a\x89"},
		{"ell", 8467, "\xe2\x84\x93"},
		{"boxvR", 9566, "\xe2\x95\x9e"},
		{"LowerRightArrow", 8600, "\xe2\x86\x98"},
		{"boxHu", 9575, "\xe2\x95\xa7"},
		{"lE", 8806, "\xe2\x89\xa6"},
		{"dzigrarr", 10239, "\xe2\x9f\xbf"},
		{"rfloor", 8971, "\xe2\x8c\x8b"},
		{"gneq", 10888, "\xe2\xaa\x88"},
		{"rightleftharpoons", 8652, "\xe2\x87\x8c"},
		{"gtquest", 10876, "\xe2\xa9\xbc"},
		{"searhk", 10533, "\xe2\xa4\xa5"},
		{"gesdoto", 10882, "\xe2\xaa\x82"},
		{"cross", 10007, "\xe2\x9c\x97"},
		{"rdquo", 8221, "\xe2\x80\x9d"},
		{"sqsupset", 8848, "\xe2\x8a\x90"},
		{"divonx", 8903, "\xe2\x8b\x87"},
		{"lat", 10923, "\xe2\xaa\xab"},
		{"rmoustache", 9137, "\xe2\x8e\xb1"},
		{"succapprox", 10936, "\xe2\xaa\xb8"},
		{"nhpar", 10994, "\xe2\xab\xb2"},
		{"sharp", 9839, "\xe2\x99\xaf"},
		{"lrcorner", 8991, "\xe2\x8c\x9f"},
		{"Vscr", 119985, "\xf0\x9d\x92\xb1"},
		{"varsigma", 962, "\xcf\x82"},
		{"bsolb", 10693, "\xe2\xa7\x85"},
		{"cupcap", 10822, "\xe2\xa9\x86"},
		{"leftrightarrow", 8596, "\xe2\x86\x94"},
		{"LeftTee", 8867, "\xe2\x8a\xa3"},
		{"Sqrt", 8730, "\xe2\x88\x9a"},
		{"Odblac", 336, "\xc5\x90"},
		{"ocir", 8858, "\xe2\x8a\x9a"},
		{"eqslantless", 10901, "\xe2\xaa\x95"},
		{"supedot", 10948, "\xe2\xab\x84"},
		{"intercal", 8890, "\xe2\x8a\xba"},
		{"Gbreve", 286, "\xc4\x9e"},
		{"xrArr", 10233, "\xe2\x9f\xb9"},
		{"NotTildeEqual", 8772, "\xe2\x89\x84"},
		{"Bfr", 120069, "\xf0\x9d\x94\x85"},
		{"Iuml", 207, "\xc3\x8f"},
		{"leg", 8922, "\xe2\x8b\x9a"},
		{"boxhU", 9576, "\xe2\x95\xa8"},
		{"Gopf", 120126, "\xf0\x9d\x94\xbe"},
		{"af", 8289, "\xe2\x81\xa1"},
		{"xwedge", 8896, "\xe2\x8b\x80"},
		{"precapprox", 10935, "\xe2\xaa\xb7"},
		{"lcedil", 316, "\xc4\xbc"},
		{"between", 8812, "\xe2\x89\xac"},
		{"Oslash", 216, "\xc3\x98"},
		{"breve", 728, "\xcb\x98"},
		{"caps", 8745, "\xe2\x88\xa9\xef\xb8\x80"},
		{"vangrt", 10652, "\xe2\xa6\x9c"},
		{"lagran", 8466, "\xe2\x84\x92"},
		{"kopf", 120156, "\xf0\x9d\x95\x9c"},
		{"ReverseUpEquilibrium", 10607, "\xe2\xa5\xaf"},
		{"nlsim", 8820, "\xe2\x89\xb4"},
		{"Cap", 8914, "\xe2\x8b\x92"},
		{"angmsdac", 10666, "\xe2\xa6\xaa"},
		{"iocy", 1105, "\xd1\x91"},
		{"seswar", 10537, "\xe2\xa4\xa9"},
		{"dzcy", 1119, "\xd1\x9f"},
		{"nsubset", 8834, "\xe2\x8a\x82\xe2\x83\x92"},
		{"cup", 8746, "\xe2\x88\xaa"},
		{"npar", 8742, "\xe2\x88\xa6"},
		{"late", 10925, "\xe2\xaa\xad"},
		{"plussim", 10790, "\xe2\xa8\xa6"},
		{"Darr", 8609, "\xe2\x86\xa1"},
		{"nexist", 8708, "\xe2\x88\x84"},
		{"cent", 162, "\xc2\xa2"},
		{"khcy", 1093, "\xd1\x85"},
		{"smallsetminus", 8726, "\xe2\x88\x96"},
		{"ycirc", 375, "\xc5\xb7"},
		{"lharu", 8636, "\xe2\x86\xbc"},
		{"upuparrows", 8648, "\xe2\x87\x88"},
		{"sigmaf", 962, "\xcf\x82"},
		{"nltri", 8938, "\xe2\x8b\xaa"},
		{"mstpos", 8766, "\xe2\x88\xbe"},
		{"Zopf", 8484, "\xe2\x84\xa4"},
		{"dwangle", 10662, "\xe2\xa6\xa6"},
		{"bowtie", 8904, "\xe2\x8b\x88"},
		{"Dfr", 120071, "\xf0\x9d\x94\x87"},
		{"iacute", 237, "\xc3\xad"},
		{"njcy", 1114, "\xd1\x9a"},
		{"cfr", 120096, "\xf0\x9d\x94\xa0"},
		{"TripleDot", 8411, "\xe2\x83\x9b"},
		{"Or", 10836, "\xe2\xa9\x94"},
		{"blk34", 9619, "\xe2\x96\x93"},
		{"equiv", 8801, "\xe2\x89\xa1"},
		{"fflig", 64256, "\xef\xac\x80"},
		{"Rang", 10219, "\xe2\x9f\xab"},
		{"Wopf", 120142, "\xf0\x9d\x95\x8e"},
		{"boxUl", 9564, "\xe2\x95\x9c"},
		{"frac12", 189, "\xc2\xbd"},
		{"clubs", 9827, "\xe2\x99\xa3"},
		{"amalg", 10815, "\xe2\xa8\xbf"},
		{"Lang", 10218, "\xe2\x9f\xaa"},
		{"asymp", 8776, "\xe2\x89\x88"},
		{"models", 8871, "\xe2\x8a\xa7"},
		{"emptyset", 8709, "\xe2\x88\x85"},
		{"Tscr", 119983, "\xf0\x9d\x92\xaf"},
		{"nleftarrow", 8602, "\xe2\x86\x9a"},
		{"Omacr", 332, "\xc5\x8c"},
		{"gtrarr", 10616, "\xe2\xa5\xb8"},
		{"excl", 33, "\x21"},
		{"rarrw", 8605, "\xe2\x86\x9d"},
		{"abreve", 259, "\xc4\x83"},
		{"CircleTimes", 8855, "\xe2\x8a\x97"},
		{"aopf", 120146, "\xf0\x9d\x95\x92"},
		{"eqvparsl", 10725, "\xe2\xa7\xa5"},
		{"boxv", 9474, "\xe2\x94\x82"},
		{"SuchThat", 8715, "\xe2\x88\x8b"},
		{"varphi", 981, "\xcf\x95"},
		{"Ropf", 8477, "\xe2\x84\x9d"},
		{"rscr", 120007, "\xf0\x9d\x93\x87"},
		{"Rrightarrow", 8667, "\xe2\x87\x9b"},
		{"equest", 8799, "\xe2\x89\x9f"},
		{"ntilde", 241, "\xc3\xb1"},
		{"Escr", 8496, "\xe2\x84\xb0"},
		{"Lopf", 120131, "\xf0\x9d\x95\x83"},
		{"GreaterGreater", 10914, "\xe2\xaa\xa2"},
		{"pluscir", 10786, "\xe2\xa8\xa2"},
		{"nsupset", 8835, "\xe2\x8a\x83\xe2\x83\x92"},
		{"uArr", 8657, "\xe2\x87\x91"},
		{"nwarhk", 10531, "\xe2\xa4\xa3"},
		{"Ycirc", 374, "\xc5\xb6"},
		{"tdot", 8411, "\xe2\x83\x9b"},
		{"circledS", 9416, "\xe2\x93\x88"},
		{"lhard", 8637, "\xe2\x86\xbd"},
		{"iukcy", 1110, "\xd1\x96"},
		{"PrecedesSlantEqual", 8828, "\xe2\x89\xbc"},
		{"Sfr", 120086, "\xf0\x9d\x94\x96"},
		{"egs", 10902, "\xe2\xaa\x96"},
		{"oelig", 339, "\xc5\x93"},
		{"bigtriangledown", 9661, "\xe2\x96\xbd"},
		{"EmptyVerySmallSquare", 9643, "\xe2\x96\xab"},
		{"Backslash", 8726, "\xe2\x88\x96"},
		{"nscr", 120003, "\xf0\x9d\x93\x83"},
		{"uogon", 371, "\xc5\xb3"},
		{"circeq", 8791, "\xe2\x89\x97"},
		{"check", 10003, "\xe2\x9c\x93"},
		{"Sup", 8913, "\xe2\x8b\x91"},
		{"Rcaron", 344, "\xc5\x98"},
		{"lneqq", 8808, "\xe2\x89\xa8"},
		{"lrhar", 8651, "\xe2\x87\x8b"},
		{"ulcorn", 8988, "\xe2\x8c\x9c"},
		{"timesd", 10800, "\xe2\xa8\xb0"},
		{"Sum", 8721, "\xe2\x88\x91"},
		{"varpropto", 8733, "\xe2\x88\x9d"},
		{"Lcaron", 317, "\xc4\xbd"},
		{"lbrkslu", 10637, "\xe2\xa6\x8d"},
		{"AElig", 198, "\xc3\x86"},
		{"varr", 8597, "\xe2\x86\x95"},
		{"nvinfin", 10718, "\xe2\xa7\x9e"},
		{"leq", 8804, "\xe2\x89\xa4"},
		{"biguplus", 10756, "\xe2\xa8\x84"},
		{"rpar", 41, "\x29"},
		{"eng", 331, "\xc5\x8b"},
		{"NegativeThinSpace", 8203, "\xe2\x80\x8b"},
		{"lesssim", 8818, "\xe2\x89\xb2"},
		{"lBarr", 10510, "\xe2\xa4\x8e"},
		{"LeftUpTeeVector", 10592, "\xe2\xa5\xa0"},
		{"gnE", 8809, "\xe2\x89\xa9"},
		{"efr", 120098, "\xf0\x9d\x94\xa2"},
		{"barvee", 8893, "\xe2\x8a\xbd"},
		{"ee", 8519, "\xe2\x85\x87"},
		{"Uogon", 370, "\xc5\xb2"},
		{"gnapprox", 10890, "\xe2\xaa\x8a"},
		{"olcir", 10686, "\xe2\xa6\xbe"},
		{"boxUL", 9565, "\xe2\x95\x9d"},
		{"Gg", 8921, "\xe2\x8b\x99"},
		{"CloseCurlyQuote", 8217, "\xe2\x80\x99"},
		{"leftharpoondown", 8637, "\xe2\x86\xbd"},
		{"vfr", 120115, "\xf0\x9d\x94\xb3"},
		{"gvertneqq", 8809, "\xe2\x89\xa9\xef\xb8\x80"},
		{"ouml", 246, "\xc3\xb6"},
		{"raemptyv", 10675, "\xe2\xa6\xb3"},
		{"Zcaron", 381, "\xc5\xbd"},
		{"scE", 10932, "\xe2\xaa\xb4"},
		{"boxvh", 9532, "\xe2\x94\xbc"},
		{"ominus", 8854, "\xe2\x8a\x96"},
		{"oopf", 120160, "\xf0\x9d\x95\xa0"},
		{"nsucceq", 10928, "\xe2\xaa\xb0\xcc\xb8"},
		{"RBarr", 10512, "\xe2\xa4\x90"},
		{"iprod", 10812, "\xe2\xa8\xbc"},
		{"lvnE", 8808, "\xe2\x89\xa8\xef\xb8\x80"},
		{"andand", 10837, "\xe2\xa9\x95"},
		{"upharpoonright", 8638, "\xe2\x86\xbe"},
		{"ncongdot", 10861, "\xe2\xa9\xad\xcc\xb8"},
		{"drcrop", 8972, "\xe2\x8c\x8c"},
		{"nsimeq", 8772, "\xe2\x89\x84"},
		{"subsub", 10965, "\xe2\xab\x95"},
		{"hardcy", 1098, "\xd1\x8a"},
		{"leqslant", 10877, "\xe2\xa9\xbd"},
		{"uharl", 8639, "\xe2\x86\xbf"},
		{"expectation", 8496, "\xe2\x84\xb0"},
		{"mdash", 8212, "\xe2\x80\x94"},
		{"VerticalTilde", 8768, "\xe2\x89\x80"},
		{"rdldhar", 10601, "\xe2\xa5\xa9"},
		{"leftharpoonup", 8636, "\xe2\x86\xbc"},
		{"mu", 956, "\xce\xbc"},
		{"curarrm", 10556, "\xe2\xa4\xbc"},
		{"Cdot", 266, "\xc4\x8a"},
		{"NotTildeTilde", 8777, "\xe2\x89\x89"},
		{"boxul", 9496, "\xe2\x94\x98"},
		{"planckh", 8462, "\xe2\x84\x8e"},
		{"CapitalDifferentialD", 8517, "\xe2\x85\x85"},
		{"boxDL", 9559, "\xe2\x95\x97"},
		{"cupbrcap", 10824, "\xe2\xa9\x88"},
		{"boxdL", 9557, "\xe2\x95\x95"},
		{"supe", 8839, "\xe2\x8a\x87"},
		{"nvlt", 60, "\x3c\xe2\x83\x92"},
		{"par", 8741, "\xe2\x88\xa5"},
		{"InvisibleComma", 8291, "\xe2\x81\xa3"},
		{"ring", 730, "\xcb\x9a"},
		{"nvap", 8781, "\xe2\x89\x8d\xe2\x83\x92"},
		{"veeeq", 8794, "\xe2\x89\x9a"},
		{"Hfr", 8460, "\xe2\x84\x8c"},
		{"dstrok", 273, "\xc4\x91"},
		{"gesles", 10900, "\xe2\xaa\x94"},
		{"dash", 8208, "\xe2\x80\x90"},
		{"SHcy", 1064, "\xd0\xa8"},
		{"congdot", 10861, "\xe2\xa9\xad"},
		{"imagline", 8464, "\xe2\x84\x90"},
		{"ncy", 1085, "\xd0\xbd"},
		{"bigstar", 9733, "\xe2\x98\x85"},
		{"REG", 174, "\xc2\xae"},
		{"triangleq", 8796, "\xe2\x89\x9c"},
		{"rsqb", 93, "\x5d"},
		{"ddarr", 8650, "\xe2\x87\x8a"},
		{"csub", 10959, "\xe2\xab\x8f"},
		{"quest", 63, "\x3f"},
		{"Star", 8902, "\xe2\x8b\x86"},
		{"LT", 60, "\x3c"},
		{"ncong", 8775, "\xe2\x89\x87"},
		{"prnE", 10933, "\xe2\xaa\xb5"},
		{"bigtriangleup", 9651, "\xe2\x96\xb3"},
		{"Tilde", 8764, "\xe2\x88\xbc"},
		{"ltrif", 9666, "\xe2\x97\x82"},
		{"ldrdhar", 10599, "\xe2\xa5\xa7"},
		{"lcaron", 318, "\xc4\xbe"},
		{"equivDD", 10872, "\xe2\xa9\xb8"},
		{"lHar", 10594, "\xe2\xa5\xa2"},
		{"vBar", 10984, "\xe2\xab\xa8"},
		{"Mopf", 120132, "\xf0\x9d\x95\x84"},
		{"LeftArrow", 8592, "\xe2\x86\x90"},
		{"Rho", 929, "\xce\xa1"},
		{"Ccirc", 264, "\xc4\x88"},
		{"ifr", 120102, "\xf0\x9d\x94\xa6"},
		{"cacute", 263, "\xc4\x87"},
		{"centerdot", 183, "\xc2\xb7"},
		{"dollar", 36, "\x24"},
		{"lang", 10216, "\xe2\x9f\xa8"},
		{"curvearrowright", 8631, "\xe2\x86\xb7"},
		{"half", 189, "\xc2\xbd"},
		{"Ecy", 1069, "\xd0\xad"},
		{"rcub", 125, "\x7d"},
		{"rcy", 1088, "\xd1\x80"},
		{"isins", 8948, "\xe2\x8b\xb4"},
		{"bsolhsub", 10184, "\xe2\x9f\x88"},
		{"boxuL", 9563, "\xe2\x95\x9b"},
		{"shchcy", 1097, "\xd1\x89"},
		{"cwconint", 8754, "\xe2\x88\xb2"},
		{"euro", 8364, "\xe2\x82\xac"},
		{"lesseqqgtr", 10891, "\xe2\xaa\x8b"},
		{"sim", 8764, "\xe2\x88\xbc"},
		{"rarrc", 10547, "\xe2\xa4\xb3"},
		{"boxdl", 9488, "\xe2\x94\x90"},
		{"Epsilon", 917, "\xce\x95"},
		{"iiiint", 10764, "\xe2\xa8\x8c"},
		{"Rightarrow", 8658, "\xe2\x87\x92"},
		{"conint", 8750, "\xe2\x88\xae"},
		{"boxDl", 9558, "\xe2\x95\x96"},
		{"kappav", 1008, "\xcf\xb0"},
		{"profsurf", 8979, "\xe2\x8c\x93"},
		{"auml", 228, "\xc3\xa4"},
		{"heartsuit", 9829, "\xe2\x99\xa5"},
		{"eacute", 233, "\xc3\xa9"},
		{"gt", 62, "\x3e"},
		{"Gcedil", 290, "\xc4\xa2"},
		{"easter", 10862, "\xe2\xa9\xae"},
		{"Tcy", 1058, "\xd0\xa2"},
		{"swarrow", 8601, "\xe2\x86\x99"},
		{"lopf", 120157, "\xf0\x9d\x95\x9d"},
		{"Agrave", 192, "\xc3\x80"},
		{"Aring", 197, "\xc3\x85"},
		{"fpartint", 10765, "\xe2\xa8\x8d"},
		{"xoplus", 10753, "\xe2\xa8\x81"},
		{"LeftDownTeeVector", 10593, "\xe2\xa5\xa1"},
		{"int", 8747, "\xe2\x88\xab"},
		{"Zeta", 918, "\xce\x96"},
		{"loz", 9674, "\xe2\x97\x8a"},
		{"ncup", 10818, "\xe2\xa9\x82"},
		{"napE", 10864, "\xe2\xa9\xb0\xcc\xb8"},
		{"csup", 10960, "\xe2\xab\x90"},
		{"Ncedil", 325, "\xc5\x85"},
		{"cuwed", 8911, "\xe2\x8b\x8f"},
		{"Dot", 168, "\xc2\xa8"},
		{"SquareIntersection", 8851, "\xe2\x8a\x93"},
		{"map", 8614, "\xe2\x86\xa6"},
		{"aelig", 230, "\xc3\xa6"},
		{"RightArrow", 8594, "\xe2\x86\x92"},
		{"rightharpoondown", 8641, "\xe2\x87\x81"},
		{"bNot", 10989, "\xe2\xab\xad"},
		{"nsccue", 8929, "\xe2\x8b\xa1"},
		{"zigrarr", 8669, "\xe2\x87\x9d"},
		{"Sacute", 346, "\xc5\x9a"},
		{"orv", 10843, "\xe2\xa9\x9b"},
		{"RightVectorBar", 10579, "\xe2\xa5\x93"},
		{"nrarrw", 8605, "\xe2\x86\x9d\xcc\xb8"},
		{"nbump", 8782, "\xe2\x89\x8e\xcc\xb8"},
		{"iquest", 191, "\xc2\xbf"},
		{"wr", 8768, "\xe2\x89\x80"},
		{"UpArrow", 8593, "\xe2\x86\x91"},
		{"notinva", 8713, "\xe2\x88\x89"},
		{"ddagger", 8225, "\xe2\x80\xa1"},
		{"nLeftarrow", 8653, "\xe2\x87\x8d"},
		{"rbbrk", 10099, "\xe2\x9d\xb3"},
		{"RightTriangle", 8883, "\xe2\x8a\xb3"},
		{"leqq", 8806, "\xe2\x89\xa6"},
		{"Vert", 8214, "\xe2\x80\x96"},
		{"gesl", 8923, "\xe2\x8b\x9b\xef\xb8\x80"},
		{"LeftTeeVector", 10586, "\xe2\xa5\x9a"},
		{"Union", 8899, "\xe2\x8b\x83"},
		{"sc", 8827, "\xe2\x89\xbb"},
		{"ofr", 120108, "\xf0\x9d\x94\xac"},
		{"quatint", 10774, "\xe2\xa8\x96"},
		{"apacir", 10863, "\xe2\xa9\xaf"},
		{"profalar", 9006, "\xe2\x8c\xae"},
		{"subsetneq", 8842, "\xe2\x8a\x8a"},
		{"Vvdash", 8874, "\xe2\x8a\xaa"},
		{"ohbar", 10677, "\xe2\xa6\xb5"},
		{"Gt", 8811, "\xe2\x89\xab"},
		{"exist", 8707, "\xe2\x88\x83"},
		{"gtrapprox", 10886, "\xe2\xaa\x86"},
		{"euml", 235, "\xc3\xab"},
		{"Equilibrium", 8652, "\xe2\x87\x8c"},
		{"aacute", 225, "\xc3\xa1"},
		{"omid", 10678, "\xe2\xa6\xb6"},
		{"loarr", 8701, "\xe2\x87\xbd"},
		{"SucceedsSlantEqual", 8829, "\xe2\x89\xbd"},
		{"angsph", 8738, "\xe2\x88\xa2"},
		{"nsmid", 8740, "\xe2\x88\xa4"},
		{"lsquor", 8218, "\xe2\x80\x9a"},
		{"cemptyv", 10674, "\xe2\xa6\xb2"},
		{"rAarr", 8667, "\xe2\x87\x9b"},
		{"searr", 8600, "\xe2\x86\x98"},
		{"complexes", 8450, "\xe2\x84\x82"},
		{"UnderParenthesis", 9181, "\xe2\x8f\x9d"},
		{"nparsl", 11005, "\xe2\xab\xbd\xe2\x83\xa5"},
		{"Lacute", 313, "\xc4\xb9"},
		{"deg", 176, "\xc2\xb0"},
		{"Racute", 340, "\xc5\x94"},
		{"Verbar", 8214, "\xe2\x80\x96"},
		{"sqcups", 8852, "\xe2\x8a\x94\xef\xb8\x80"},
		{"Hopf", 8461, "\xe2\x84\x8d"},
		{"naturals", 8469, "\xe2\x84\x95"},
		{"Cedilla", 184, "\xc2\xb8"},
		{"exponentiale", 8519, "\xe2\x85\x87"},
		{"vnsup", 8835, "\xe2\x8a\x83\xe2\x83\x92"},
		{"leftrightarrows", 8646, "\xe2\x87\x86"},
		{"Laplacetrf", 8466, "\xe2\x84\x92"},
		{"vartriangleright", 8883, "\xe2\x8a\xb3"},
		{"rtri", 9657, "\xe2\x96\xb9"},
		{"gE", 8807, "\xe2\x89\xa7"},
		{"SmallCircle", 8728, "\xe2\x88\x98"},
		{"diamondsuit", 9830, "\xe2\x99\xa6"},
		{"Otilde", 213, "\xc3\x95"},
		{"lneq", 10887, "\xe2\xaa\x87"},
		{"lesdoto", 10881, "\xe2\xaa\x81"},
		{"ltquest", 10875, "\xe2\xa9\xbb"},
		{"thinsp", 8201, "\xe2\x80\x89"},
		{"barwed", 8965, "\xe2\x8c\x85"},
		{"elsdot", 10903, "\xe2\xaa\x97"},
		{"circ", 710, "\xcb\x86"},
		{"ni", 8715, "\xe2\x88\x8b"},
		{"mlcp", 10971, "\xe2\xab\x9b"},
		{"Vdash", 8873, "\xe2\x8a\xa9"},
		{"ShortRightArrow", 8594, "\xe2\x86\x92"},
		{"upharpoonleft", 8639, "\xe2\x86\xbf"},
		{"UnderBracket", 9141, "\xe2\x8e\xb5"},
		{"rAtail", 10524, "\xe2\xa4\x9c"},
		{"iopf", 120154, "\xf0\x9d\x95\x9a"},
		{"longleftarrow", 10229, "\xe2\x9f\xb5"},
		{"Zacute", 377, "\xc5\xb9"},
		{"duhar", 10607, "\xe2\xa5\xaf"},
		{"Mfr", 120080, "\xf0\x9d\x94\x90"},
		{"prnap", 10937, "\xe2\xaa\xb9"},
		{"eqcirc", 8790, "\xe2\x89\x96"},
		{"rarrlp", 8620, "\xe2\x86\xac"},
		{"le", 8804, "\xe2\x89\xa4"},
		{"Oscr", 119978, "\xf0\x9d\x92\xaa"},
		{"langd", 10641, "\xe2\xa6\x91"},
		{"Ucirc", 219, "\xc3\x9b"},
		{"precnapprox", 10937, "\xe2\xaa\xb9"},
		{"succcurlyeq", 8829, "\xe2\x89\xbd"},
		{"Tau", 932, "\xce\xa4"},
		{"larr", 8592, "\xe2\x86\x90"},
		{"neArr", 8663, "\xe2\x87\x97"},
		{"subsim", 10951, "\xe2\xab\x87"},
		{"DScy", 1029, "\xd0\x85"},
		{"preccurlyeq", 8828, "\xe2\x89\xbc"},
		{"NotLessLess", 8810, "\xe2\x89\xaa\xcc\xb8"},
		{"succnapprox", 10938, "\xe2\xaa\xba"},
		{"prcue", 8828, "\xe2\x89\xbc"},
		{"Downarrow", 8659, "\xe2\x87\x93"},
		{"angmsdah", 10671, "\xe2\xa6\xaf"},
		{"Emacr", 274, "\xc4\x92"},
		{"lsh", 8624, "\xe2\x86\xb0"},
		{"simne", 8774, "\xe2\x89\x86"},
		{"Bumpeq", 8782, "\xe2\x89\x8e"},
		{"RightUpTeeVector", 10588, "\xe2\xa5\x9c"},
		{"Sigma", 931, "\xce\xa3"},
		{"nvltrie", 8884, "\xe2\x8a\xb4\xe2\x83\x92"},
		{"lfr", 120105, "\xf0\x9d\x94\xa9"},
		{"emsp13", 8196, "\xe2\x80\x84"},
		{"parsl", 11005, "\xe2\xab\xbd"},
		{"ucirc", 251, "\xc3\xbb"},
		{"gsiml", 10896, "\xe2\xaa\x90"},
		{"xsqcup", 10758, "\xe2\xa8\x86"},
		{"Omicron", 927, "\xce\x9f"},
		{"gsime", 10894, "\xe2\xaa\x8e"},
		{"circlearrowleft", 8634, "\xe2\x86\xba"},
		{"sqsupe", 8850, "\xe2\x8a\x92"},
		{"supE", 10950, "\xe2\xab\x86"},
		{"dlcrop", 8973, "\xe2\x8c\x8d"},
		{"RightDownTeeVector", 10589, "\xe2\xa5\x9d"},
		{"Colone", 10868, "\xe2\xa9\xb4"},
		{"awconint", 8755, "\xe2\x88\xb3"},
		{"smte", 10924, "\xe2\xaa\xac"},
		{"lEg", 10891, "\xe2\xaa\x8b"},
		{"circledast", 8859, "\xe2\x8a\x9b"},
		{"ecolon", 8789, "\xe2\x89\x95"},
		{"rect", 9645, "\xe2\x96\xad"},
		{"Equal", 10869, "\xe2\xa9\xb5"},
		{"nwnear", 10535, "\xe2\xa4\xa7"},
		{"capdot", 10816, "\xe2\xa9\x80"},
		{"straightphi", 981, "\xcf\x95"},
		{"forkv", 10969, "\xe2\xab\x99"},
		{"ZHcy", 1046, "\xd0\x96"},
		{"Element", 8712, "\xe2\x88\x88"},
		{"rthree", 8908, "\xe2\x8b\x8c"},
		{"vzigzag", 10650, "\xe2\xa6\x9a"},
		{"hybull", 8259, "\xe2\x81\x83"},
		{"intprod", 10812, "\xe2\xa8\xbc"},
		{"HumpEqual", 8783, "\xe2\x89\x8f"},
		{"bigsqcup", 10758, "\xe2\xa8\x86"},
		{"mp", 8723, "\xe2\x88\x93"},
		{"lescc", 10920, "\xe2\xaa\xa8"},
		{"NotPrecedes", 8832, "\xe2\x8a\x80"},
		{"wedge", 8743, "\xe2\x88\xa7"},
		{"Supset", 8913, "\xe2\x8b\x91"},
		{"pm", 177, "\xc2\xb1"},
		{"kfr", 120104, "\xf0\x9d\x94\xa8"},
		{"ufisht", 10622, "\xe2\xa5\xbe"},
		{"ecaron", 283, "\xc4\x9b"},
		{"chcy", 1095, "\xd1\x87"},
		{"Esim", 10867, "\xe2\xa9\xb3"},
		{"fltns", 9649, "\xe2\x96\xb1"},
		{"nsce", 10928, "\xe2\xaa\xb0\xcc\xb8"},
		{"hookrightarrow", 8618, "\xe2\x86\xaa"},
		{"semi", 59, "\x3b"},
		{"ges", 10878, "\xe2\xa9\xbe"},
		{"approxeq", 8778, "\xe2\x89\x8a"},
		{"rarrsim", 10612, "\xe2\xa5\xb4"},
		{"boxhD", 9573, "\xe2\x95\xa5"},
		{"varpi", 982, "\xcf\x96"},
		{"larrb", 8676, "\xe2\x87\xa4"},
		{"copf", 120148, "\xf0\x9d\x95\x94"},
		{"Dopf", 120123, "\xf0\x9d\x94\xbb"},
		{"LeftVector", 8636, "\xe2\x86\xbc"},
		{"iff", 8660, "\xe2\x87\x94"},
		{"lnap", 10889, "\xe2\xaa\x89"},
		{"NotGreaterFullEqual", 8807, "\xe2\x89\xa7\xcc\xb8"},
		{"varrho", 1009, "\xcf\xb1"},
		{"NotSucceeds", 8833, "\xe2\x8a\x81"},
		{"ltrPar", 10646, "\xe2\xa6\x96"},
		{"nlE", 8806, "\xe2\x89\xa6\xcc\xb8"},
		{"Zfr", 8488, "\xe2\x84\xa8"},
		{"LeftArrowBar", 8676, "\xe2\x87\xa4"},
		{"boxplus", 8862, "\xe2\x8a\x9e"},
		{"sqsube", 8849, "\xe2\x8a\x91"},
		{"Re", 8476, "\xe2\x84\x9c"},
		{"Wfr", 120090, "\xf0\x9d\x94\x9a"},
		{"epsi", 949, "\xce\xb5"},
		{"oacute", 243, "\xc3\xb3"},
		{"bdquo", 8222, "\xe2\x80\x9e"},
		{"wscr", 120012, "\xf0\x9d\x93\x8c"},
		{"bullet", 8226, "\xe2\x80\xa2"},
		{"frown", 8994, "\xe2\x8c\xa2"},
		{"siml", 10909, "\xe2\xaa\x9d"},
		{"Rarr", 8608, "\xe2\x86\xa0"},
		{"Scaron", 352, "\xc5\xa0"},
		{"gtreqqless", 10892, "\xe2\xaa\x8c"},
		{"Larr", 8606, "\xe2\x86\x9e"},
		{"notniva", 8716, "\xe2\x88\x8c"},
		{"gg", 8811, "\xe2\x89\xab"},
		{"phmmat", 8499, "\xe2\x84\xb3"},
		{"boxVL", 9571, "\xe2\x95\xa3"},
		{"sigmav", 962, "\xcf\x82"},
		{"order", 8500, "\xe2\x84\xb4"},
		{"subsup", 10963, "\xe2\xab\x93"},
		{"afr", 120094, "\xf0\x9d\x94\x9e"},
		{"lbrace", 123, "\x7b"},
		{"urcorn", 8989, "\xe2\x8c\x9d"},
		{"Im", 8465, "\xe2\x84\x91"},
		{"CounterClockwiseContourIntegral", 8755, "\xe2\x88\xb3"},
		{"lne", 10887, "\xe2\xaa\x87"},
		{"chi", 967, "\xcf\x87"},
		{"cudarrl", 10552, "\xe2\xa4\xb8"},
		{"ang", 8736, "\xe2\x88\xa0"},
		{"isindot", 8949, "\xe2\x8b\xb5"},
		{"Lfr", 120079, "\xf0\x9d\x94\x8f"},
		{"Rsh", 8625, "\xe2\x86\xb1"},
		{"Ocy", 1054, "\xd0\x9e"},
		{"nvrArr", 10499, "\xe2\xa4\x83"},
		{"otimes", 8855, "\xe2\x8a\x97"},
		{"eqslantgtr", 10902, "\xe2\xaa\x96"},
		{"Rfr", 8476, "\xe2\x84\x9c"},
		{"blacktriangleleft", 9666, "\xe2\x97\x82"},
		{"Lsh", 8624, "\xe2\x86\xb0"},
		{"boxvr", 9500, "\xe2\x94\x9c"},
		{"scedil", 351, "\xc5\x9f"},
		{"iuml", 239, "\xc3\xaf"},
		{"NJcy", 1034, "\xd0\x8a"},
		{"Dagger", 8225, "\xe2\x80\xa1"},
		{"rarrap", 10613, "\xe2\xa5\xb5"},
		{"udblac", 369, "\xc5\xb1"},
		{"Sopf", 120138, "\xf0\x9d\x95\x8a"},
		{"scnsim", 8937, "\xe2\x8b\xa9"},
		{"hbar", 8463, "\xe2\x84\x8f"},
		{"frac15", 8533, "\xe2\x85\x95"},
		{"sup3", 179, "\xc2\xb3"},
		{"NegativeThickSpace", 8203, "\xe2\x80\x8b"},
		{"npr", 8832, "\xe2\x8a\x80"},
		{"doteq", 8784, "\xe2\x89\x90"},
		{"subrarr", 10617, "\xe2\xa5\xb9"},
		{"SquareSubset", 8847, "\xe2\x8a\x8f"},
		{"vprop", 8733, "\xe2\x88\x9d"},
		{"OpenCurlyQuote", 8216, "\xe2\x80\x98"},
		{"supseteq", 8839, "\xe2\x8a\x87"},
		{"nRightarrow", 8655, "\xe2\x87\x8f"},
		{"Longleftarrow", 10232, "\xe2\x9f\xb8"},
		{"lsquo", 8216, "\xe2\x80\x98"},
		{"hstrok", 295, "\xc4\xa7"},
		{"NotTilde", 8769, "\xe2\x89\x81"},
		{"ogt", 10689, "\xe2\xa7\x81"},
		{"block", 9608, "\xe2\x96\x88"},
		{"minusd", 8760, "\xe2\x88\xb8"},
		{"esdot", 8784, "\xe2\x89\x90"},
		{"nsim", 8769, "\xe2\x89\x81"},
		{"scsim", 8831, "\xe2\x89\xbf"},
		{"boxVl", 9570, "\xe2\x95\xa2"},
		{"ltimes", 8905, "\xe2\x8b\x89"},
		{"thkap", 8776, "\xe2\x89\x88"},
		{"vnsub", 8834, "\xe2\x8a\x82\xe2\x83\x92"},
		{"thetasym", 977, "\xcf\x91"},
		{"eopf", 120150, "\xf0\x9d\x95\x96"},
		{"image", 8465, "\xe2\x84\x91"},
		{"doteqdot", 8785, "\xe2\x89\x91"},
		{"Udblac", 368, "\xc5\xb0"},
		{"gnsim", 8935, "\xe2\x8b\xa7"},
		{"yicy", 1111, "\xd1\x97"},
		{"vopf", 120167, "\xf0\x9d\x95\xa7"},
		{"DDotrahd", 10513, "\xe2\xa4\x91"},
		{"Iota", 921, "\xce\x99"},
		{"GJcy", 1027, "\xd0\x83"},
		{"rightthreetimes", 8908, "\xe2\x8b\x8c"},
		{"nrtri", 8939, "\xe2\x8b\xab"},
		{"TildeFullEqual", 8773, "\xe2\x89\x85"},
		{"Dcaron", 270, "\xc4\x8e"},
		{"ccaron", 269, "\xc4\x8d"},
		{"lacute", 314, "\xc4\xba"},
		{"VerticalBar", 8739, "\xe2\x88\xa3"},
		{"Igrave", 204, "\xc3\x8c"},
		{"boxH", 9552, "\xe2\x95\x90"},
		{"Pfr", 120083, "\xf0\x9d\x94\x93"},
		{"equals", 61, "\x3d"},
		{"rbrack", 93, "\x5d"},
		{"OverParenthesis", 9180, "\xe2\x8f\x9c"},
		{"in", 8712, "\xe2\x88\x88"},
		{"llcorner", 8990, "\xe2\x8c\x9e"},
		{"mcomma", 10793, "\xe2\xa8\xa9"},
		{"NotGreater", 8815, "\xe2\x89\xaf"},
		{"midcir", 10992, "\xe2\xab\xb0"},
		{"Edot", 278, "\xc4\x96"},
		{"oplus", 8853, "\xe2\x8a\x95"},
		{"geqq", 8807, "\xe2\x89\xa7"},
		{"curvearrowleft", 8630, "\xe2\x86\xb6"},
		{"Poincareplane", 8460, "\xe2\x84\x8c"},
		{"yscr", 120014, "\xf0\x9d\x93\x8e"},
		{"ccaps", 10829, "\xe2\xa9\x8d"},
		{"rpargt", 10644, "\xe2\xa6\x94"},
		{"topfork", 10970, "\xe2\xab\x9a"},
		{"Gamma", 915, "\xce\x93"},
		{"umacr", 363, "\xc5\xab"},
		{"frac13", 8531, "\xe2\x85\x93"},
		{"cirfnint", 10768, "\xe2\xa8\x90"},
		{"xlArr", 10232, "\xe2\x9f\xb8"},
		{"digamma", 989, "\xcf\x9d"},
		{"Hat", 94, "\x5e"},
		{"lates", 10925, "\xe2\xaa\xad\xef\xb8\x80"},
		{"lgE", 10897, "\xe2\xaa\x91"},
		{"commat", 64, "\x40"},
		{"NotPrecedesSlantEqual", 8928, "\xe2\x8b\xa0"},
		{"phone", 9742, "\xe2\x98\x8e"},
		{"Ecirc", 202, "\xc3\x8a"},
		{"lt", 60, "\x3c"},
		{"intcal", 8890, "\xe2\x8a\xba"},
		{"xdtri", 9661, "\xe2\x96\xbd"},
		{"Abreve", 258, "\xc4\x82"},
		{"gopf", 120152, "\xf0\x9d\x95\x98"},
		{"Xopf", 120143, "\xf0\x9d\x95\x8f"},
		{"Iacute", 205, "\xc3\x8d"},
		{"Aopf", 120120, "\xf0\x9d\x94\xb8"},
		{"gbreve", 287, "\xc4\x9f"},
		{"nleq", 8816, "\xe2\x89\xb0"},
		{"xopf", 120169, "\xf0\x9d\x95\xa9"},
		{"SquareSupersetEqual", 8850, "\xe2\x8a\x92"},
		{"NotLessTilde", 8820, "\xe2\x89\xb4"},
		{"SubsetEqual", 8838, "\xe2\x8a\x86"},
		{"Sc", 10940, "\xe2\xaa\xbc"},
		{"sdote", 10854, "\xe2\xa9\xa6"},
		{"loplus", 10797, "\xe2\xa8\xad"},
		{"zfr", 120119, "\xf0\x9d\x94\xb7"},
		{"subseteqq", 10949, "\xe2\xab\x85"},
		{"Vdashl", 10982, "\xe2\xab\xa6"},
		{"integers", 8484, "\xe2\x84\xa4"},
		{"Umacr", 362, "\xc5\xaa"},
		{"dopf", 120149, "\xf0\x9d\x95\x95"},
		{"RightDownVectorBar", 10581, "\xe2\xa5\x95"},
		{"angmsdaf", 10669, "\xe2\xa6\xad"},
		{"Jfr", 120077, "\xf0\x9d\x94\x8d"},
		{"bernou", 8492, "\xe2\x84\xac"},
		{"lceil", 8968, "\xe2\x8c\x88"},
		{"nvsim", 8764, "\xe2\x88\xbc\xe2\x83\x92"},
		{"NotSucceedsSlantEqual", 8929, "\xe2\x8b\xa1"},
		{"hearts", 9829, "\xe2\x99\xa5"},
		{"vee", 8744, "\xe2\x88\xa8"},
		{"LJcy", 1033, "\xd0\x89"},
		{"nlt", 8814, "\xe2\x89\xae"},
		{"because", 8757, "\xe2\x88\xb5"},
		{"hairsp", 8202, "\xe2\x80\x8a"},
		{"comma", 44, "\x2c"},
		{"iecy", 1077, "\xd0\xb5"},
		{"npre", 10927, "\xe2\xaa\xaf\xcc\xb8"},
		{"NotSquareSubset", 8847, "\xe2\x8a\x8f\xcc\xb8"},
		{"mscr", 120002, "\xf0\x9d\x93\x82"},
		{"jopf", 120155, "\xf0\x9d\x95\x9b"},
		{"bumpE", 10926, "\xe2\xaa\xae"},
		{"thicksim", 8764, "\xe2\x88\xbc"},
		{"Nfr", 120081, "\xf0\x9d\x94\x91"},
		{"yucy", 1102, "\xd1\x8e"},
		{"notinvc", 8950, "\xe2\x8b\xb6"},
		{"lstrok", 322, "\xc5\x82"},
		{"robrk", 10215, "\xe2\x9f\xa7"},
		{"LeftTriangleBar", 10703, "\xe2\xa7\x8f"},
		{"hksearow", 10533, "\xe2\xa4\xa5"},
		{"bigcap", 8898, "\xe2\x8b\x82"},
		{"udhar", 10606, "\xe2\xa5\xae"},
		{"Yscr", 119988, "\xf0\x9d\x92\xb4"},
		{"smeparsl", 10724, "\xe2\xa7\xa4"},
		{"NotLess", 8814, "\xe2\x89\xae"},
		{"dcaron", 271, "\xc4\x8f"},
		{"ange", 10660, "\xe2\xa6\xa4"},
		{"dHar", 10597, "\xe2\xa5\xa5"},
		{"UpperRightArrow", 8599, "\xe2\x86\x97"},
		{"trpezium", 9186, "\xe2\x8f\xa2"},
		{"boxminus", 8863, "\xe2\x8a\x9f"},
		{"notni", 8716, "\xe2\x88\x8c"},
		{"dtrif", 9662, "\xe2\x96\xbe"},
		{"nhArr", 8654, "\xe2\x87\x8e"},
		{"larrpl", 10553, "\xe2\xa4\xb9"},
		{"simeq", 8771, "\xe2\x89\x83"},
		{"geqslant", 10878, "\xe2\xa9\xbe"},
		{"RightUpVectorBar", 10580, "\xe2\xa5\x94"},
		{"nsc", 8833, "\xe2\x8a\x81"},
		{"div", 247, "\xc3\xb7"},
		{"orslope", 10839, "\xe2\xa9\x97"},
		{"lparlt", 10643, "\xe2\xa6\x93"},
		{"trie", 8796, "\xe2\x89\x9c"},
		{"cirmid", 10991, "\xe2\xab\xaf"},
		{"wp", 8472, "\xe2\x84\x98"},
		{"dagger", 8224, "\xe2\x80\xa0"},
		{"utri", 9653, "\xe2\x96\xb5"},
		{"supnE", 10956, "\xe2\xab\x8c"},
		{"eg", 10906, "\xe2\xaa\x9a"},
		{"LeftDownVector", 8643, "\xe2\x87\x83"},
		{"NotLessEqual", 8816, "\xe2\x89\xb0"},
		{"Bopf", 120121, "\xf0\x9d\x94\xb9"},
		{"LongLeftRightArrow", 10231, "\xe2\x9f\xb7"},
		{"Gfr", 120074, "\xf0\x9d\x94\x8a"},
		{"sqsubseteq", 8849, "\xe2\x8a\x91"},
		{"ograve", 242, "\xc3\xb2"},
		{"larrhk", 8617, "\xe2\x86\xa9"},
		{"sigma", 963, "\xcf\x83"},
		{"NotSquareSupersetEqual", 8931, "\xe2\x8b\xa3"},
		{"gvnE", 8809, "\xe2\x89\xa9\xef\xb8\x80"},
		{"timesbar", 10801, "\xe2\xa8\xb1"},
		{"Iukcy", 1030, "\xd0\x86"},
		{"bscr", 119991, "\xf0\x9d\x92\xb7"},
		{"Exists", 8707, "\xe2\x88\x83"},
		{"tscr", 120009, "\xf0\x9d\x93\x89"},
		{"tcy", 1090, "\xd1\x82"},
		{"nwarr", 8598, "\xe2\x86\x96"},
		{"hoarr", 8703, "\xe2\x87\xbf"},
		{"lnapprox", 10889, "\xe2\xaa\x89"},
		{"nu", 957, "\xce\xbd"},
		{"bcy", 1073, "\xd0\xb1"},
		{"ndash", 8211, "\xe2\x80\x93"},
		{"smt", 10922, "\xe2\xaa\xaa"},
		{"scaron", 353, "\xc5\xa1"},
		{"IOcy", 1025, "\xd0\x81"},
		{"Ifr", 8465, "\xe2\x84\x91"},
		{"cularrp", 10557, "\xe2\xa4\xbd"},
		{"lvertneqq", 8808, "\xe2\x89\xa8\xef\xb8\x80"},
		{"nlarr", 8602, "\xe2\x86\x9a"},
		{"colon", 58, "\x3a"},
		{"ddotseq", 10871, "\xe2\xa9\xb7"},
		{"zacute", 378, "\xc5\xba"},
		{"DoubleVerticalBar", 8741, "\xe2\x88\xa5"},
		{"larrfs", 10525, "\xe2\xa4\x9d"},
		{"NotExists", 8708, "\xe2\x88\x84"},
		{"geq", 8805, "\xe2\x89\xa5"},
		{"Ffr", 120073, "\xf0\x9d\x94\x89"},
		{"divide", 247, "\xc3\xb7"},
		{"blank", 9251, "\xe2\x90\xa3"},
		{"IEcy", 1045, "\xd0\x95"},
		{"ordm", 186, "\xc2\xba"},
		{"fopf", 120151, "\xf0\x9d\x95\x97"},
		{"ecir", 8790, "\xe2\x89\x96"},
		{"complement", 8705, "\xe2\x88\x81"},
		{"top", 8868, "\xe2\x8a\xa4"},
		{"DoubleContourIntegral", 8751, "\xe2\x88\xaf"},
		{"nisd", 8954, "\xe2\x8b\xba"},
		{"bcong", 8780, "\xe2\x89\x8c"},
		{"plusdu", 10789, "\xe2\xa8\xa5"},
		{"TildeTilde", 8776, "\xe2\x89\x88"},
		{"lnE", 8808, "\xe2\x89\xa8"},
		{"DoubleLongRightArrow", 10233, "\xe2\x9f\xb9"},
		{"nsubseteqq", 10949, "\xe2\xab\x85\xcc\xb8"},
		{"DownTeeArrow", 8615, "\xe2\x86\xa7"},
		{"Cscr", 119966, "\xf0\x9d\x92\x9e"},
		{"NegativeVeryThinSpace", 8203, "\xe2\x80\x8b"},
		{"emsp", 8195, "\xe2\x80\x83"},
		{"vartriangleleft", 8882, "\xe2\x8a\xb2"},
		{"ropar", 10630, "\xe2\xa6\x86"},
		{"checkmark", 10003, "\xe2\x9c\x93"},
		{"Ycy", 1067, "\xd0\xab"},
		{"supset", 8835, "\xe2\x8a\x83"},
		{"gneqq", 8809, "\xe2\x89\xa9"},
		{"Lstrok", 321, "\xc5\x81"},
		{"AMP", 38, "\x26"},
		{"acE", 8766, "\xe2\x88\xbe\xcc\xb3"},
		{"sqsupseteq", 8850, "\xe2\x8a\x92"},
		{"nle", 8816, "\xe2\x89\xb0"},
		{"nesear", 10536, "\xe2\xa4\xa8"},
		{"LeftDownVectorBar", 10585, "\xe2\xa5\x99"},
		{"Integral", 8747, "\xe2\x88\xab"},
		{"Beta", 914, "\xce\x92"},
		{"nvdash", 8876, "\xe2\x8a\xac"},
		{"nges", 10878, "\xe2\xa9\xbe\xcc\xb8"},
		{"demptyv", 10673, "\xe2\xa6\xb1"},
		{"eta", 951, "\xce\xb7"},
		{"GreaterSlantEqual", 10878, "\xe2\xa9\xbe"},
		{"ccedil", 231, "\xc3\xa7"},
		{"pfr", 120109, "\xf0\x9d\x94\xad"},
		{"bbrktbrk", 9142, "\xe2\x8e\xb6"},
		{"mcy", 1084, "\xd0\xbc"},
		{"Not", 10988, "\xe2\xab\xac"},
		{"qscr", 120006, "\xf0\x9d\x93\x86"},
		{"zwj", 8205, "\xe2\x80\x8d"},
		{"ntrianglerighteq", 8941, "\xe2\x8b\xad"},
		{"permil", 8240, "\xe2\x80\xb0"},
		{"squarf", 9642, "\xe2\x96\xaa"},
		{"apos", 39, "\x27"},
		{"lrm", 8206, "\xe2\x80\x8e"},
		{"male", 9794, "\xe2\x99\x82"},
		{"agrave", 224, "\xc3\xa0"},
		{"Lt", 8810, "\xe2\x89\xaa"},
		{"capand", 10820, "\xe2\xa9\x84"},
		{"aring", 229, "\xc3\xa5"},
		{"Jukcy", 1028, "\xd0\x84"},
		{"bumpe", 8783, "\xe2\x89\x8f"},
		{"dd", 8518, "\xe2\x85\x86"},
		{"tscy", 1094, "\xd1\x86"},
		{"oS", 9416, "\xe2\x93\x88"},
		{"succeq", 10928, "\xe2\xaa\xb0"},
		{"xharr", 10231, "\xe2\x9f\xb7"},
		{"pluse", 10866, "\xe2\xa9\xb2"},
		{"rfisht", 10621, "\xe2\xa5\xbd"},
		{"HorizontalLine", 9472, "\xe2\x94\x80"},
		{"DiacriticalAcute", 180, "\xc2\xb4"},
		{"hfr", 120101, "\xf0\x9d\x94\xa5"},
		{"preceq", 10927, "\xe2\xaa\xaf"},
		{"rationals", 8474, "\xe2\x84\x9a"},
		{"Auml", 196, "\xc3\x84"},
		{"LeftRightArrow", 8596, "\xe2\x86\x94"},
		{"blacktriangleright", 9656, "\xe2\x96\xb8"},
		{"dharr", 8642, "\xe2\x87\x82"},
		{"isin", 8712, "\xe2\x88\x88"},
		{"ldrushar", 10571, "\xe2\xa5\x8b"},
		{"squ", 9633, "\xe2\x96\xa1"},
		{"rbrksld", 10638, "\xe2\xa6\x8e"},
		{"bigwedge", 8896, "\xe2\x8b\x80"},
		{"swArr", 8665, "\xe2\x87\x99"},
		{"IJlig", 306, "\xc4\xb2"},
		{"harr", 8596, "\xe2\x86\x94"},
		{"range", 10661, "\xe2\xa6\xa5"},
		{"urtri", 9721, "\xe2\x97\xb9"},
		{"NotVerticalBar", 8740, "\xe2\x88\xa4"},
		{"ic", 8291, "\xe2\x81\xa3"},
		{"solbar", 9023, "\xe2\x8c\xbf"},
		{"approx", 8776, "\xe2\x89\x88"},
		{"SquareSuperset", 8848, "\xe2\x8a\x90"},
		{"numsp", 8199, "\xe2\x80\x87"},
		{"nLt", 8810, "\xe2\x89\xaa\xe2\x83\x92"},
		{"tilde", 732, "\xcb\x9c"},
		{"rlarr", 8644, "\xe2\x87\x84"},
		{"langle", 10216, "\xe2\x9f\xa8"},
		{"nleqslant", 10877, "\xe2\xa9\xbd\xcc\xb8"},
		{"Nacute", 323, "\xc5\x83"},
		{"NotLeftTriangle", 8938, "\xe2\x8b\xaa"},
		{"sopf", 120164, "\xf0\x9d\x95\xa4"},
		{"xmap", 10236, "\xe2\x9f\xbc"},
		{"supne", 8843, "\xe2\x8a\x8b"},
		{"Int", 8748, "\xe2\x88\xac"},
		{"nsupseteqq", 10950, "\xe2\xab\x86\xcc\xb8"},
		{"circlearrowright", 8635, "\xe2\x86\xbb"},
		{"NotCongruent", 8802, "\xe2\x89\xa2"},
		{"Scedil", 350, "\xc5\x9e"},
		{"raquo", 187, "\xc2\xbb"},
		{"ycy", 1099, "\xd1\x8b"},
		{"notinvb", 8951, "\xe2\x8b\xb7"},
		{"andv", 10842, "\xe2\xa9\x9a"},
		{"nap", 8777, "\xe2\x89\x89"},
		{"shcy", 1096, "\xd1\x88"},
		{"ssetmn", 8726, "\xe2\x88\x96"},
		{"downarrow", 8595, "\xe2\x86\x93"},
		{"gesdotol", 10884, "\xe2\xaa\x84"},
		{"Congruent", 8801, "\xe2\x89\xa1"},
		{"pound", 163, "\xc2\xa3"},
		{"ZeroWidthSpace", 8203, "\xe2\x80\x8b"},
		{"rdca", 10551, "\xe2\xa4\xb7"},
		{"rmoust", 9137, "\xe2\x8e\xb1"},
		{"zcy", 1079, "\xd0\xb7"},
		{"Square", 9633, "\xe2\x96\xa1"},
		{"subE", 10949, "\xe2\xab\x85"},
		{"infintie", 10717, "\xe2\xa7\x9d"},
		{"Cayleys", 8493, "\xe2\x84\xad"},
		{"lsaquo", 8249, "\xe2\x80\xb9"},
		{"realpart", 8476, "\xe2\x84\x9c"},
		{"nprec", 8832, "\xe2\x8a\x80"},
		{"RightTriangleBar", 10704, "\xe2\xa7\x90"},
		{"Kopf", 120130, "\xf0\x9d\x95\x82"},
		{"Ubreve", 364, "\xc5\xac"},
		{"Uopf", 120140, "\xf0\x9d\x95\x8c"},
		{"trianglelefteq", 8884, "\xe2\x8a\xb4"},
		{"rotimes", 10805, "\xe2\xa8\xb5"},
		{"qfr", 120110, "\xf0\x9d\x94\xae"},
		{"gtcc", 10919, "\xe2\xaa\xa7"},
		{"fnof", 402, "\xc6\x92"},
		{"tritime", 10811, "\xe2\xa8\xbb"},
		{"andslope", 10840, "\xe2\xa9\x98"},
		{"harrw", 8621, "\xe2\x86\xad"},
		{"NotSquareSuperset", 8848, "\xe2\x8a\x90\xcc\xb8"},
		{"Amacr", 256, "\xc4\x80"},
		{"OpenCurlyDoubleQuote", 8220, "\xe2\x80\x9c"},
		{"thorn", 254, "\xc3\xbe"},
		{"ordf", 170, "\xc2\xaa"},
		{"natur", 9838, "\xe2\x99\xae"},
		{"xi", 958, "\xce\xbe"},
		{"infin", 8734, "\xe2\x88\x9e"},
		{"nspar", 8742, "\xe2\x88\xa6"},
		{"Jcy", 1049, "\xd0\x99"},
		{"DownLeftTeeVector", 10590, "\xe2\xa5\x9e"},
		{"rbarr", 10509, "\xe2\xa4\x8d"},
		{"Xi", 926, "\xce\x9e"},
		{"bull", 8226, "\xe2\x80\xa2"},
		{"cuesc", 8927, "\xe2\x8b\x9f"},
		{"backcong", 8780, "\xe2\x89\x8c"},
		{"frac35", 8535, "\xe2\x85\x97"},
		{"hscr", 119997, "\xf0\x9d\x92\xbd"},
		{"LessEqualGreater", 8922, "\xe2\x8b\x9a"},
		{"Implies", 8658, "\xe2\x87\x92"},
		{"ETH", 208, "\xc3\x90"},
		{"Yacute", 221, "\xc3\x9d"},
		{"shy", 173, "\xc2\xad"},
		{"Rarrtl", 10518, "\xe2\xa4\x96"},
		{"sup1", 185, "\xc2\xb9"},
		{"reals", 8477, "\xe2\x84\x9d"},
		{"blacklozenge", 10731, "\xe2\xa7\xab"},
		{"ncedil", 326, "\xc5\x86"},
		{"Lambda", 923, "\xce\x9b"},
		{"uopf", 120166, "\xf0\x9d\x95\xa6"},
		{"bigodot", 10752, "\xe2\xa8\x80"},
		{"ubreve", 365, "\xc5\xad"},
		{"drbkarow", 10512, "\xe2\xa4\x90"},
		{"els", 10901, "\xe2\xaa\x95"},
		{"shortparallel", 8741, "\xe2\x88\xa5"},
		{"Pcy", 1055, "\xd0\x9f"},
		{"dsol", 10742, "\xe2\xa7\xb6"},
		{"supsim", 10952, "\xe2\xab\x88"},
		{"Longrightarrow", 10233, "\xe2\x9f\xb9"},
		{"ThickSpace", 8287, "\xe2\x81\x9f\xe2\x80\x8a"},
		{"Itilde", 296, "\xc4\xa8"},
		{"nparallel", 8742, "\xe2\x88\xa6"},
		{"And", 10835, "\xe2\xa9\x93"},
		{"boxhd", 9516, "\xe2\x94\xac"},
		{"Dashv", 10980, "\xe2\xab\xa4"},
		{"NotSuperset", 8835, "\xe2\x8a\x83\xe2\x83\x92"},
		{"Eta", 919, "\xce\x97"},
		{"Qopf", 8474, "\xe2\x84\x9a"},
		{"period", 46, "\x2e"},
		{"angmsd", 8737, "\xe2\x88\xa1"},
		{"fllig", 64258, "\xef\xac\x82"},
		{"cuvee", 8910, "\xe2\x8b\x8e"},
		{"wedbar", 10847, "\xe2\xa9\x9f"},
		{"Fscr", 8497, "\xe2\x84\xb1"},
		{"veebar", 8891, "\xe2\x8a\xbb"},
		{"Longleftrightarrow", 10234, "\xe2\x9f\xba"},
		{"reg", 174, "\xc2\xae"},
		{"NegativeMediumSpace", 8203, "\xe2\x80\x8b"},
		{"Upsi", 978, "\xcf\x92"},
		{"Mellintrf", 8499, "\xe2\x84\xb3"},
		{"boxHU", 9577, "\xe2\x95\xa9"},
		{"bne", 61, "\x3d\xe2\x83\xa5"},
		{"frac56", 8538, "\xe2\x85\x9a"},
		{"utrif", 9652, "\xe2\x96\xb4"},
		{"LeftTriangle", 8882, "\xe2\x8a\xb2"},
		{"nsime", 8772, "\xe2\x89\x84"},
		{"rcedil", 343, "\xc5\x97"},
		{"aogon", 261, "\xc4\x85"},
		{"uHar", 10595, "\xe2\xa5\xa3"},
		{"ForAll", 8704, "\xe2\x88\x80"},
		{"prE", 10931, "\xe2\xaa\xb3"},
		{"boxV", 9553, "\xe2\x95\x91"},
		{"softcy", 1100, "\xd1\x8c"},
		{"hercon", 8889, "\xe2\x8a\xb9"},
		{"lmoustache", 9136, "\xe2\x8e\xb0"},
		{"Product", 8719, "\xe2\x88\x8f"},
		{"lsimg", 10895, "\xe2\xaa\x8f"},
		{"verbar", 124, "\x7c"},
		{"ofcir", 10687, "\xe2\xa6\xbf"},
		{"curlyeqprec", 8926, "\xe2\x8b\x9e"},
		{"ldquo", 8220, "\xe2\x80\x9c"},
		{"bot", 8869, "\xe2\x8a\xa5"},
		{"Psi", 936, "\xce\xa8"},
		{"OElig", 338, "\xc5\x92"},
		{"DownRightVectorBar", 10583, "\xe2\xa5\x97"},
		{"minusb", 8863, "\xe2\x8a\x9f"},
		{"Iscr", 8464, "\xe2\x84\x90"},
		{"Tcedil", 354, "\xc5\xa2"},
		{"ffilig", 64259, "\xef\xac\x83"},
		{"Gcy", 1043, "\xd0\x93"},
		{"oline", 8254, "\xe2\x80\xbe"},
		{"bottom", 8869, "\xe2\x8a\xa5"},
		{"nVDash", 8879, "\xe2\x8a\xaf"},
		{"lessdot", 8918, "\xe2\x8b\x96"},
		{"cups", 8746, "\xe2\x88\xaa\xef\xb8\x80"},
		{"gla", 10917, "\xe2\xaa\xa5"},
		{"hellip", 8230, "\xe2\x80\xa6"},
		{"hookleftarrow", 8617, "\xe2\x86\xa9"},
		{"Cup", 8915, "\xe2\x8b\x93"},
		{"upsi", 965, "\xcf\x85"},
		{"DownArrowBar", 10515, "\xe2\xa4\x93"},
		{"lowast", 8727, "\xe2\x88\x97"},
		{"profline", 8978, "\xe2\x8c\x92"},
		{"ngsim", 8821, "\xe2\x89\xb5"},
		{"boxhu", 9524, "\xe2\x94\xb4"},
		{"operp", 10681, "\xe2\xa6\xb9"},
		{"cap", 8745, "\xe2\x88\xa9"},
		{"Hcirc", 292, "\xc4\xa4"},
		{"Ncy", 1053, "\xd0\x9d"},
		{"zeetrf", 8488, "\xe2\x84\xa8"},
		{"cuepr", 8926, "\xe2\x8b\x9e"},
		{"supsetneq", 8843, "\xe2\x8a\x8b"},
		{"lfloor", 8970, "\xe2\x8c\x8a"},
		{"ngtr", 8815, "\xe2\x89\xaf"},
		{"ccups", 10828, "\xe2\xa9\x8c"},
		{"pscr", 120005, "\xf0\x9d\x93\x85"},
		{"Cfr", 8493, "\xe2\x84\xad"},
		{"dtri", 9663, "\xe2\x96\xbf"},
		{"icirc", 238, "\xc3\xae"},
		{"leftarrow", 8592, "\xe2\x86\x90"},
		{"vdash", 8866, "\xe2\x8a\xa2"},
		{"leftrightharpoons", 8651, "\xe2\x87\x8b"},
		{"rightrightarrows", 8649, "\xe2\x87\x89"},
		{"strns", 175, "\xc2\xaf"},
		{"intlarhk", 10775, "\xe2\xa8\x97"},
		{"downharpoonright", 8642, "\xe2\x87\x82"},
		{"yacute", 253, "\xc3\xbd"},
		{"boxUr", 9561, "\xe2\x95\x99"},
		{"triangleleft", 9667, "\xe2\x97\x83"},
		{"DiacriticalDot", 729, "\xcb\x99"},
		{"thetav", 977, "\xcf\x91"},
		{"OverBracket", 9140, "\xe2\x8e\xb4"},
		{"PrecedesTilde", 8830, "\xe2\x89\xbe"},
		{"rtrie", 8885, "\xe2\x8a\xb5"},
		{"Scirc", 348, "\xc5\x9c"},
		{"vsupne", 8843, "\xe2\x8a\x8b\xef\xb8\x80"},
		{"OverBrace", 9182, "\xe2\x8f\x9e"},
		{"Yfr", 120092, "\xf0\x9d\x94\x9c"},
		{"scnE", 10934, "\xe2\xaa\xb6"},
		{"simlE", 10911, "\xe2\xaa\x9f"},
		{"Proportional", 8733, "\xe2\x88\x9d"},
		{"edot", 279, "\xc4\x97"},
		{"loang", 10220, "\xe2\x9f\xac"},
		{"gesdot", 10880, "\xe2\xaa\x80"},
		{"DownBreve", 785, "\xcc\x91"},
		{"pcy", 1087, "\xd0\xbf"},
		{"Succeeds", 8827, "\xe2\x89\xbb"},
		{"mfr", 120106, "\xf0\x9d\x94\xaa"},
		{"Leftarrow", 8656, "\xe2\x87\x90"},
		{"boxDr", 9555, "\xe2\x95\x93"},
		{"Nscr", 119977, "\xf0\x9d\x92\xa9"},
		{"diam", 8900, "\xe2\x8b\x84"},
		{"CHcy", 1063, "\xd0\xa7"},
		{"boxdr", 9484, "\xe2\x94\x8c"},
		{"rlm", 8207, "\xe2\x80\x8f"},
		{"Coproduct", 8720, "\xe2\x88\x90"},
		{"RightTeeArrow", 8614, "\xe2\x86\xa6"},
		{"tridot", 9708, "\xe2\x97\xac"},
		{"ldquor", 8222, "\xe2\x80\x9e"},
		{"sol", 47, "\x2f"},
		{"ecirc", 234, "\xc3\xaa"},
		{"DoubleLeftArrow", 8656, "\xe2\x87\x90"},
		{"Gscr", 119970, "\xf0\x9d\x92\xa2"},
		{"ap", 8776, "\xe2\x89\x88"},
		{"rbrke", 10636, "\xe2\xa6\x8c"},
		{"LeftFloor", 8970, "\xe2\x8c\x8a"},
		{"blk12", 9618, "\xe2\x96\x92"},
		{"Conint", 8751, "\xe2\x88\xaf"},
		{"triangledown", 9663, "\xe2\x96\xbf"},
		{"Icy", 1048, "\xd0\x98"},
		{"backprime", 8245, "\xe2\x80\xb5"},
		{"longleftrightarrow", 10231, "\xe2\x9f\xb7"},
		{"ntriangleleft", 8938, "\xe2\x8b\xaa"},
		{"copy", 169, "\xc2\xa9"},
		{"mapstodown", 8615, "\xe2\x86\xa7"},
		{"seArr", 8664, "\xe2\x87\x98"},
		{"ENG", 330, "\xc5\x8a"},
		{"DoubleRightArrow", 8658, "\xe2\x87\x92"},
		{"tfr", 120113, "\xf0\x9d\x94\xb1"},
		{"rharul", 10604, "\xe2\xa5\xac"},
		{"bfr", 120095, "\xf0\x9d\x94\x9f"},
		{"origof", 8886, "\xe2\x8a\xb6"},
		{"Therefore", 8756, "\xe2\x88\xb4"},
		{"glE", 10898, "\xe2\xaa\x92"},
		{"leftarrowtail", 8610, "\xe2\x86\xa2"},
		{"NotEqual", 8800, "\xe2\x89\xa0"},
		{"LeftCeiling", 8968, "\xe2\x8c\x88"},
		{"lArr", 8656, "\xe2\x87\x90"},
		{"subseteq", 8838, "\xe2\x8a\x86"},
		{"larrbfs", 10527, "\xe2\xa4\x9f"},
		{"Gammad", 988, "\xcf\x9c"},
		{"rtriltri", 10702, "\xe2\xa7\x8e"},
		{"Fcy", 1060, "\xd0\xa4"},
		{"Vopf", 120141, "\xf0\x9d\x95\x8d"},
		{"lrarr", 8646, "\xe2\x87\x86"},
		{"delta", 948, "\xce\xb4"},
		{"xodot", 10752, "\xe2\xa8\x80"},
		{"larrtl", 8610, "\xe2\x86\xa2"},
		{"gsim", 8819, "\xe2\x89\xb3"},
		{"ratail", 10522, "\xe2\xa4\x9a"},
		{"vsubne", 8842, "\xe2\x8a\x8a\xef\xb8\x80"},
		{"boxur", 9492, "\xe2\x94\x94"},
		{"succsim", 8831, "\xe2\x89\xbf"},
		{"triplus", 10809, "\xe2\xa8\xb9"},
		{"nless", 8814, "\xe2\x89\xae"},
		{"uharr", 8638, "\xe2\x86\xbe"},
		{"lambda", 955, "\xce\xbb"},
		{"uuml", 252, "\xc3\xbc"},
		{"horbar", 8213, "\xe2\x80\x95"},
		{"ccirc", 265, "\xc4\x89"},
		{"sqcup", 8852, "\xe2\x8a\x94"},
		{"Pscr", 119979, "\xf0\x9d\x92\xab"},
		{"supsup", 10966, "\xe2\xab\x96"},
		{"Cacute", 262, "\xc4\x86"},
		{"upsih", 978, "\xcf\x92"},
		{"precsim", 8830, "\xe2\x89\xbe"},
		{"longrightarrow", 10230, "\xe2\x9f\xb6"},
		{"circledR", 174, "\xc2\xae"},
		{"UpTeeArrow", 8613, "\xe2\x86\xa5"},
		{"bepsi", 1014, "\xcf\xb6"},
		{"oast", 8859, "\xe2\x8a\x9b"},
		{"yfr", 120118, "\xf0\x9d\x94\xb6"},
		{"rdsh", 8627, "\xe2\x86\xb3"},
		{"Ograve", 210, "\xc3\x92"},
		{"LeftVectorBar", 10578, "\xe2\xa5\x92"},
		{"NotNestedLessLess", 10913, "\xe2\xaa\xa1\xcc\xb8"},
		{"Jscr", 119973, "\xf0\x9d\x92\xa5"},
		{"psi", 968, "\xcf\x88"},
		{"orarr", 8635, "\xe2\x86\xbb"},
		{"Subset", 8912, "\xe2\x8b\x90"},
		{"curarr", 8631, "\xe2\x86\xb7"},
		{"CirclePlus", 8853, "\xe2\x8a\x95"},
		{"gtrless", 8823, "\xe2\x89\xb7"},
		{"nvle", 8804, "\xe2\x89\xa4\xe2\x83\x92"},
		{"prop", 8733, "\xe2\x88\x9d"},
		{"gEl", 10892, "\xe2\xaa\x8c"},
		{"gtlPar", 10645, "\xe2\xa6\x95"},
		{"frasl", 8260, "\xe2\x81\x84"},
		{"nearr", 8599, "\xe2\x86\x97"},
		{"NotSubsetEqual", 8840, "\xe2\x8a\x88"},
		{"planck", 8463, "\xe2\x84\x8f"},
		{"Uuml", 220, "\xc3\x9c"},
		{"spadesuit", 9824, "\xe2\x99\xa0"},
		{"sect", 167, "\xc2\xa7"},
		{"cdot", 267, "\xc4\x8b"},
		{"boxVh", 9579, "\xe2\x95\xab"},
		{"zscr", 120015, "\xf0\x9d\x93\x8f"},
		{"nsqsube", 8930, "\xe2\x8b\xa2"},
		{"grave", 96, "\x60"},
		{"angrtvb", 8894, "\xe2\x8a\xbe"},
		{"MediumSpace", 8287, "\xe2\x81\x9f"},
		{"Ntilde", 209, "\xc3\x91"},
		{"solb", 10692, "\xe2\xa7\x84"},
		{"angzarr", 9084, "\xe2\x8d\xbc"},
		{"nopf", 120159, "\xf0\x9d\x95\x9f"},
		{"rtrif", 9656, "\xe2\x96\xb8"},
		{"nrightarrow", 8603, "\xe2\x86\x9b"},
		{"Kappa", 922, "\xce\x9a"},
		{"simrarr", 10610, "\xe2\xa5\xb2"},
		{"imacr", 299, "\xc4\xab"},
		{"vrtri", 8883, "\xe2\x8a\xb3"},
		{"part", 8706, "\xe2\x88\x82"},
		{"esim", 8770, "\xe2\x89\x82"},
		{"atilde", 227, "\xc3\xa3"},
		{"DownRightTeeVector", 10591, "\xe2\xa5\x9f"},
		{"jcirc", 309, "\xc4\xb5"},
		{"Ecaron", 282, "\xc4\x9a"},
		{"VerticalSeparator", 10072, "\xe2\x9d\x98"},
		{"rHar", 10596, "\xe2\xa5\xa4"},
		{"rcaron", 345, "\xc5\x99"},
		{"subnE", 10955, "\xe2\xab\x8b"},
		{"ii", 8520, "\xe2\x85\x88"},
		{"Cconint", 8752, "\xe2\x88\xb0"},
		{"Mcy", 1052, "\xd0\x9c"},
		{"eqcolon", 8789, "\xe2\x89\x95"},
		{"cupor", 10821, "\xe2\xa9\x85"},
		{"DoubleUpArrow", 8657, "\xe2\x87\x91"},
		{"boxbox", 10697, "\xe2\xa7\x89"},
		{"setminus", 8726, "\xe2\x88\x96"},
		{"Lleftarrow", 8666, "\xe2\x87\x9a"},
		{"nang", 8736, "\xe2\x88\xa0\xe2\x83\x92"},
		{"TRADE", 8482, "\xe2\x84\xa2"},
		{"urcorner", 8989, "\xe2\x8c\x9d"},
		{"lsqb", 91, "\x5b"},
		{"cupcup", 10826, "\xe2\xa9\x8a"},
		{"kjcy", 1116, "\xd1\x9c"},
		{"llhard", 10603, "\xe2\xa5\xab"},
		{"mumap", 8888, "\xe2\x8a\xb8"},
		{"iiint", 8749, "\xe2\x88\xad"},
		{"RightTee", 8866, "\xe2\x8a\xa2"},
		{"Tcaron", 356, "\xc5\xa4"},
		{"bigcirc", 9711, "\xe2\x97\xaf"},
		{"trianglerighteq", 8885, "\xe2\x8a\xb5"},
		{"NotLessGreater", 8824, "\xe2\x89\xb8"},
		{"hArr", 8660, "\xe2\x87\x94"},
		{"ocy", 1086, "\xd0\xbe"},
		{"tosa", 10537, "\xe2\xa4\xa9"},
		{"twixt", 8812, "\xe2\x89\xac"},
		{"square", 9633, "\xe2\x96\xa1"},
		{"Otimes", 10807, "\xe2\xa8\xb7"},
		{"Kcedil", 310, "\xc4\xb6"},
		{"beth", 8502, "\xe2\x84\xb6"},
		{"triminus", 10810, "\xe2\xa8\xba"},
		{"nlArr", 8653, "\xe2\x87\x8d"},
		{"Oacute", 211, "\xc3\x93"},
		{"zwnj", 8204, "\xe2\x80\x8c"},
		{"ll", 8810, "\xe2\x89\xaa"},
		{"smashp", 10803, "\xe2\xa8\xb3"},
		{"ngeqq", 8807, "\xe2\x89\xa7\xcc\xb8"},
		{"rnmid", 10990, "\xe2\xab\xae"},
		{"nwArr", 8662, "\xe2\x87\x96"},
		{"RightUpDownVector", 10575, "\xe2\xa5\x8f"},
		{"lbbrk", 10098, "\xe2\x9d\xb2"},
		{"compfn", 8728, "\xe2\x88\x98"},
		{"eDDot", 10871, "\xe2\xa9\xb7"},
		{"Jsercy", 1032, "\xd0\x88"},
		{"HARDcy", 1066, "\xd0\xaa"},
		{"nexists", 8708, "\xe2\x88\x84"},
		{"theta", 952, "\xce\xb8"},
		{"plankv", 8463, "\xe2\x84\x8f"},
		{"sup2", 178, "\xc2\xb2"},
		{"lessapprox", 10885, "\xe2\xaa\x85"},
		{"gdot", 289, "\xc4\xa1"},
		{"angmsdae", 10668, "\xe2\xa6\xac"},
		{"Superset", 8835, "\xe2\x8a\x83"},
		{"prap", 10935, "\xe2\xaa\xb7"},
		{"Zscr", 119989, "\xf0\x9d\x92\xb5"},
		{"nsucc", 8833, "\xe2\x8a\x81"},
		{"supseteqq", 10950, "\xe2\xab\x86"},
		{"UpTee", 8869, "\xe2\x8a\xa5"},
		{"LowerLeftArrow", 8601, "\xe2\x86\x99"},
		{"ssmile", 8995, "\xe2\x8c\xa3"},
		{"niv", 8715, "\xe2\x88\x8b"},
		{"bigvee", 8897, "\xe2\x8b\x81"},
		{"kscr", 120000, "\xf0\x9d\x93\x80"},
		{"xutri", 9651, "\xe2\x96\xb3"},
		{"caret", 8257, "\xe2\x81\x81"},
		{"caron", 711, "\xcb\x87"},
		{"Wedge", 8896, "\xe2\x8b\x80"},
		{"sdotb", 8865, "\xe2\x8a\xa1"},
		{"bigoplus", 10753, "\xe2\xa8\x81"},
		{"Breve", 728, "\xcb\x98"},
		{"ImaginaryI", 8520, "\xe2\x85\x88"},
		{"longmapsto", 10236, "\xe2\x9f\xbc"},
		{"boxVH", 9580, "\xe2\x95\xac"},
		{"lozenge", 9674, "\xe2\x97\x8a"},
		{"toea", 10536, "\xe2\xa4\xa8"},
		{"nbumpe", 8783, "\xe2\x89\x8f\xcc\xb8"},
		{"gcirc", 285, "\xc4\x9d"},
		{"NotHumpEqual", 8783, "\xe2\x89\x8f\xcc\xb8"},
		{"pre", 10927, "\xe2\xaa\xaf"},
		{"ascr", 119990, "\xf0\x9d\x92\xb6"},
		{"Acirc", 194, "\xc3\x82"},
		{"questeq", 8799, "\xe2\x89\x9f"},
		{"ncaron", 328, "\xc5\x88"},
		{"LeftTeeArrow", 8612, "\xe2\x86\xa4"},
		{"xcirc", 9711, "\xe2\x97\xaf"},
		{"swarr", 8601, "\xe2\x86\x99"},
		{"MinusPlus", 8723, "\xe2\x88\x93"},
		{"plus", 43, "\x2b"},
		{"NotDoubleVerticalBar", 8742, "\xe2\x88\xa6"},
		{"rppolint", 10770, "\xe2\xa8\x92"},
		{"NotTildeFullEqual", 8775, "\xe2\x89\x87"},
		{"ltdot", 8918, "\xe2\x8b\x96"},
		{"NotNestedGreaterGreater", 10914, "\xe2\xaa\xa2\xcc\xb8"},
		{"Lscr", 8466, "\xe2\x84\x92"},
		{"pitchfork", 8916, "\xe2\x8b\x94"},
		{"Eopf", 120124, "\xf0\x9d\x94\xbc"},
		{"ropf", 120163, "\xf0\x9d\x95\xa3"},
		{"Delta", 916, "\xce\x94"},
		{"lozf", 10731, "\xe2\xa7\xab"},
		{"RightTeeVector", 10587, "\xe2\xa5\x9b"},
		{"UpDownArrow", 8597, "\xe2\x86\x95"},
		{"bump", 8782, "\xe2\x89\x8e"},
		{"Rscr", 8475, "\xe2\x84\x9b"},
		{"slarr", 8592, "\xe2\x86\x90"},
		{"lcy", 1083, "\xd0\xbb"},
		{"Vee", 8897, "\xe2\x8b\x81"},
		{"Iogon", 302, "\xc4\xae"},
		{"minus", 8722, "\xe2\x88\x92"},
		{"GreaterFullEqual", 8807, "\xe2\x89\xa7"},
		{"xhArr", 10234, "\xe2\x9f\xba"},
		{"shortmid", 8739, "\xe2\x88\xa3"},
		{"DoubleDownArrow", 8659, "\xe2\x87\x93"},
		{"Wscr", 119986, "\xf0\x9d\x92\xb2"},
		{"rang", 10217, "\xe2\x9f\xa9"},
		{"lcub", 123, "\x7b"},
		{"mnplus", 8723, "\xe2\x88\x93"},
		{"ulcrop", 8975, "\xe2\x8c\x8f"},
		{"wfr", 120116, "\xf0\x9d\x94\xb4"},
		{"DifferentialD", 8518, "\xe2\x85\x86"},
		{"ThinSpace", 8201, "\xe2\x80\x89"},
		{"NotGreaterGreater", 8811, "\xe2\x89\xab\xcc\xb8"},
		{"Topf", 120139, "\xf0\x9d\x95\x8b"},
		{"sbquo", 8218, "\xe2\x80\x9a"},
		{"sdot", 8901, "\xe2\x8b\x85"},
		{"DoubleLeftTee", 10980, "\xe2\xab\xa4"},
		{"vBarv", 10985, "\xe2\xab\xa9"},
		{"subne", 8842, "\xe2\x8a\x8a"},
		{"gtrdot", 8919, "\xe2\x8b\x97"},
		{"opar", 10679, "\xe2\xa6\xb7"},
		{"apid", 8779, "\xe2\x89\x8b"},
		{"Cross", 10799, "\xe2\xa8\xaf"},
		{"lhblk", 9604, "\xe2\x96\x84"},
		{"capcap", 10827, "\xe2\xa9\x8b"},
		{"midast", 42, "\x2a"},
		{"lscr", 120001, "\xf0\x9d\x93\x81"},
		{"nGt", 8811, "\xe2\x89\xab\xe2\x83\x92"},
		{"Euml", 203, "\xc3\x8b"},
		{"blacktriangledown", 9662, "\xe2\x96\xbe"},
		{"Rcy", 1056, "\xd0\xa0"},
		{"dfisht", 10623, "\xe2\xa5\xbf"},
		{"dashv", 8867, "\xe2\x8a\xa3"},
		{"ast", 42, "\x2a"},
		{"ContourIntegral", 8750, "\xe2\x88\xae"},
		{"Ofr", 120082, "\xf0\x9d\x94\x92"},
		{"Lcy", 1051, "\xd0\x9b"},
		{"nltrie", 8940, "\xe2\x8b\xac"},
		{"ShortUpArrow", 8593, "\xe2\x86\x91"},
		{"acy", 1072, "\xd0\xb0"},
		{"rightarrow", 8594, "\xe2\x86\x92"},
		{"UnderBar", 95, "\x5f"},
		{"LongLeftArrow", 10229, "\xe2\x9f\xb5"},
		{"andd", 10844, "\xe2\xa9\x9c"},
		{"xlarr", 10229, "\xe2\x9f\xb5"},
		{"percnt", 37, "\x25"},
		{"rharu", 8640, "\xe2\x87\x80"},
		{"plusdo", 8724, "\xe2\x88\x94"},
		{"TScy", 1062, "\xd0\xa6"},
		{"kcy", 1082, "\xd0\xba"},
		{"boxVR", 9568, "\xe2\x95\xa0"},
		{"looparrowleft", 8619, "\xe2\x86\xab"},
		{"scirc", 349, "\xc5\x9d"},
		{"drcorn", 8991, "\xe2\x8c\x9f"},
		{"iiota", 8489, "\xe2\x84\xa9"},
		{"Zcy", 1047, "\xd0\x97"},
		{"frac58", 8541, "\xe2\x85\x9d"},
		{"alpha", 945, "\xce\xb1"},
		{"daleth", 8504, "\xe2\x84\xb8"},
		{"gtreqless", 8923, "\xe2\x8b\x9b"},
		{"tstrok", 359, "\xc5\xa7"},
		{"plusb", 8862, "\xe2\x8a\x9e"},
		{"odsold", 10684, "\xe2\xa6\xbc"},
		{"varsupsetneqq", 10956, "\xe2\xab\x8c\xef\xb8\x80"},
		{"otilde", 245, "\xc3\xb5"},
		{"gtcir", 10874, "\xe2\xa9\xba"},
		{"lltri", 9722, "\xe2\x97\xba"},
		{"rx", 8478, "\xe2\x84\x9e"},
		{"ljcy", 1113, "\xd1\x99"},
		{"parsim", 10995, "\xe2\xab\xb3"},
		{"NotElement", 8713, "\xe2\x88\x89"},
		{"plusmn", 177, "\xc2\xb1"},
		{"varsubsetneq", 8842, "\xe2\x8a\x8a\xef\xb8\x80"},
		{"subset", 8834, "\xe2\x8a\x82"},
		{"awint", 10769, "\xe2\xa8\x91"},
		{"laemptyv", 10676, "\xe2\xa6\xb4"},
		{"phiv", 981, "\xcf\x95"},
		{"sfrown", 8994, "\xe2\x8c\xa2"},
		{"DoubleUpDownArrow", 8661, "\xe2\x87\x95"},
		{"lpar", 40, "\x28"},
		{"frac45", 8536, "\xe2\x85\x98"},
		{"rBarr", 10511, "\xe2\xa4\x8f"},
		{"npolint", 10772, "\xe2\xa8\x94"},
		{"emacr", 275, "\xc4\x93"},
		{"maltese", 10016, "\xe2\x9c\xa0"},
		{"PlusMinus", 177, "\xc2\xb1"},
		{"ReverseEquilibrium", 8651, "\xe2\x87\x8b"},
		{"oscr", 8500, "\xe2\x84\xb4"},
		{"blacksquare", 9642, "\xe2\x96\xaa"},
		{"TSHcy", 1035, "\xd0\x8b"},
		{"gap", 10886, "\xe2\xaa\x86"},
		{"xnis", 8955, "\xe2\x8b\xbb"},
		{"Ll", 8920, "\xe2\x8b\x98"},
		{"PrecedesEqual", 10927, "\xe2\xaa\xaf"},
		{"incare", 8453, "\xe2\x84\x85"},
		{"nharr", 8622, "\xe2\x86\xae"},
		{"varnothing", 8709, "\xe2\x88\x85"},
		{"ShortDownArrow", 8595, "\xe2\x86\x93"},
		{"nbsp", 160, " "},
		{"asympeq", 8781, "\xe2\x89\x8d"},
		{"rbrkslu", 10640, "\xe2\xa6\x90"},
		{"rho", 961, "\xcf\x81"},
		{"Mscr", 8499, "\xe2\x84\xb3"},
		{"eth", 240, "\xc3\xb0"},
		{"suplarr", 10619, "\xe2\xa5\xbb"},
		{"Tab", 9, "\x09"},
		{"omicron", 959, "\xce\xbf"},
		{"blacktriangle", 9652, "\xe2\x96\xb4"},
		{"nldr", 8229, "\xe2\x80\xa5"},
		{"downharpoonleft", 8643, "\xe2\x87\x83"},
		{"circledcirc", 8858, "\xe2\x8a\x9a"},
		{"leftleftarrows", 8647, "\xe2\x87\x87"},
		{"NotHumpDownHump", 8782, "\xe2\x89\x8e\xcc\xb8"},
		{"nvgt", 62, "\x3e\xe2\x83\x92"},
		{"rhard", 8641, "\xe2\x87\x81"},
		{"nGg", 8921, "\xe2\x8b\x99\xcc\xb8"},
		{"lurdshar", 10570, "\xe2\xa5\x8a"},
		{"cirE", 10691, "\xe2\xa7\x83"},
		{"isinE", 8953, "\xe2\x8b\xb9"},
		{"eparsl", 10723, "\xe2\xa7\xa3"},
		{"RightAngleBracket", 10217, "\xe2\x9f\xa9"},
		{"hcirc", 293, "\xc4\xa5"},
		{"bumpeq", 8783, "\xe2\x89\x8f"},
		{"cire", 8791, "\xe2\x89\x97"},
		{"dotplus", 8724, "\xe2\x88\x94"},
		{"itilde", 297, "\xc4\xa9"},
		{"uwangle", 10663, "\xe2\xa6\xa7"},
		{"rlhar", 8652, "\xe2\x87\x8c"},
		{"rbrace", 125, "\x7d"},
		{"mid", 8739, "\xe2\x88\xa3"},
		{"el", 10905, "\xe2\xaa\x99"},
		{"KJcy", 1036, "\xd0\x8c"},
		{"odiv", 10808, "\xe2\xa8\xb8"},
		{"amacr", 257, "\xc4\x81"},
		{"qprime", 8279, "\xe2\x81\x97"},
		{"tcedil", 355, "\xc5\xa3"},
		{"UpArrowDownArrow", 8645, "\xe2\x87\x85"},
		{"spades", 9824, "\xe2\x99\xa0"},
		{"napos", 329, "\xc5\x89"},
		{"straightepsilon", 1013, "\xcf\xb5"},
		{"CupCap", 8781, "\xe2\x89\x8d"},
		{"Oopf", 120134, "\xf0\x9d\x95\x86"},
		{"sub", 8834, "\xe2\x8a\x82"},
		{"ohm", 937, "\xce\xa9"},
		{"UnderBrace", 9183, "\xe2\x8f\x9f"},
		{"looparrowright", 8620, "\xe2\x86\xac"},
		{"xotime", 10754, "\xe2\xa8\x82"},
		{"ntgl", 8825, "\xe2\x89\xb9"},
		{"minusdu", 10794, "\xe2\xa8\xaa"},
		{"rarrb", 8677, "\xe2\x87\xa5"},
		{"nvlArr", 10498, "\xe2\xa4\x82"},
		{"triangle", 9653, "\xe2\x96\xb5"},
		{"nacute", 324, "\xc5\x84"},
		{"boxHD", 9574, "\xe2\x95\xa6"},
		{"ratio", 8758, "\xe2\x88\xb6"},
		{"larrsim", 10611, "\xe2\xa5\xb3"},
		{"LessLess", 10913, "\xe2\xaa\xa1"},
		{"yacy", 1103, "\xd1\x8f"},
		{"ctdot", 8943, "\xe2\x8b\xaf"},
		{"and", 8743, "\xe2\x88\xa7"},
		{"lrtri", 8895, "\xe2\x8a\xbf"},
		{"eDot", 8785, "\xe2\x89\x91"},
		{"sqsub", 8847, "\xe2\x8a\x8f"},
		{"real", 8476, "\xe2\x84\x9c"},
		{"Dcy", 1044, "\xd0\x94"},
		{"vartheta", 977, "\xcf\x91"},
		{"nsub", 8836, "\xe2\x8a\x84"},
		{"DownTee", 8868, "\xe2\x8a\xa4"},
		{"acute", 180, "\xc2\xb4"},
		{"GreaterLess", 8823, "\xe2\x89\xb7"},
		{"supplus", 10944, "\xe2\xab\x80"},
		{"Vbar", 10987, "\xe2\xab\xab"},
		{"divideontimes", 8903, "\xe2\x8b\x87"},
		{"lsim", 8818, "\xe2\x89\xb2"},
		{"nearhk", 10532, "\xe2\xa4\xa4"},
		{"nLtv", 8810, "\xe2\x89\xaa\xcc\xb8"},
		{"RuleDelayed", 10740, "\xe2\xa7\xb4"},
		{"smile", 8995, "\xe2\x8c\xa3"},
		{"coprod", 8720, "\xe2\x88\x90"},
		{"imof", 8887, "\xe2\x8a\xb7"},
		{"ecy", 1101, "\xd1\x8d"},
		{"RightCeiling", 8969, "\xe2\x8c\x89"},
		{"dlcorn", 8990, "\xe2\x8c\x9e"},
		{"Nu", 925, "\xce\x9d"},
		{"frac18", 8539, "\xe2\x85\x9b"},
		{"diamond", 8900, "\xe2\x8b\x84"},
		{"Icirc", 206, "\xc3\x8e"},
		{"ngeq", 8817, "\xe2\x89\xb1"},
		{"epsilon", 949, "\xce\xb5"},
		{"fork", 8916, "\xe2\x8b\x94"},
		{"xrarr", 10230, "\xe2\x9f\xb6"},
		{"racute", 341, "\xc5\x95"},
		{"ntlg", 8824, "\xe2\x89\xb8"},
		{"xvee", 8897, "\xe2\x8b\x81"},
		{"LeftArrowRightArrow", 8646, "\xe2\x87\x86"},
		{"DownLeftRightVector", 10576, "\xe2\xa5\x90"},
		{"Eacute", 201, "\xc3\x89"},
		{"gimel", 8503, "\xe2\x84\xb7"},
		{"rtimes", 8906, "\xe2\x8b\x8a"},
		{"forall", 8704, "\xe2\x88\x80"},
		{"DiacriticalDoubleAcute", 733, "\xcb\x9d"},
		{"dArr", 8659, "\xe2\x87\x93"},
		{"fallingdotseq", 8786, "\xe2\x89\x92"},
		{"Aogon", 260, "\xc4\x84"},
		{"PartialD", 8706, "\xe2\x88\x82"},
		{"mapstoup", 8613, "\xe2\x86\xa5"},
		{"die", 168, "\xc2\xa8"},
		{"ngt", 8815, "\xe2\x89\xaf"},
		{"vcy", 1074, "\xd0\xb2"},
		{"fjlig", 102, "\x66\x6a"},
		{"submult", 10945, "\xe2\xab\x81"},
		{"ubrcy", 1118, "\xd1\x9e"},
		{"ovbar", 9021, "\xe2\x8c\xbd"},
		{"bsime", 8909, "\xe2\x8b\x8d"},
		{"precnsim", 8936, "\xe2\x8b\xa8"},
		{"DiacriticalTilde", 732, "\xcb\x9c"},
		{"cwint", 8753, "\xe2\x88\xb1"},
		{"Scy", 1057, "\xd0\xa1"},
		{"NotGreaterEqual", 8817, "\xe2\x89\xb1"},
		{"boxUR", 9562, "\xe2\x95\x9a"},
		{"LessSlantEqual", 10877, "\xe2\xa9\xbd"},
		{"Barwed", 8966, "\xe2\x8c\x86"},
		{"supdot", 10942, "\xe2\xaa\xbe"},
		{"gel", 8923, "\xe2\x8b\x9b"},
		{"iscr", 119998, "\xf0\x9d\x92\xbe"},
		{"doublebarwedge", 8966, "\xe2\x8c\x86"},
		{"Idot", 304, "\xc4\xb0"},
		{"DoubleDot", 168, "\xc2\xa8"},
		{"rsquo", 8217, "\xe2\x80\x99"},
		{"subsetneqq", 10955, "\xe2\xab\x8b"},
		{"UpEquilibrium", 10606, "\xe2\xa5\xae"},
		{"copysr", 8471, "\xe2\x84\x97"},
		{"RightDoubleBracket", 10215, "\xe2\x9f\xa7"},
		{"LeftRightVector", 10574, "\xe2\xa5\x8e"},
		{"DownLeftVectorBar", 10582, "\xe2\xa5\x96"},
		{"suphsub", 10967, "\xe2\xab\x97"},
		{"cedil", 184, "\xc2\xb8"},
		{"prurel", 8880, "\xe2\x8a\xb0"},
		{"imagpart", 8465, "\xe2\x84\x91"},
		{"Hscr", 8459, "\xe2\x84\x8b"},
		{"jmath", 567, "\xc8\xb7"},
		{"nrtrie", 8941, "\xe2\x8b\xad"},
		{"nsup", 8837, "\xe2\x8a\x85"},
		{"Ubrcy", 1038, "\xd0\x8e"},
		{"succnsim", 8937, "\xe2\x8b\xa9"},
		{"nesim", 8770, "\xe2\x89\x82\xcc\xb8"},
		{"varepsilon", 1013, "\xcf\xb5"},
		{"DoubleRightTee", 8872, "\xe2\x8a\xa8"},
		{"not", 172, "\xc2\xac"},
		{"lesdot", 10879, "\xe2\xa9\xbf"},
		{"backepsilon", 1014, "\xcf\xb6"},
		{"srarr", 8594, "\xe2\x86\x92"},
		{"varsubsetneqq", 10955, "\xe2\xab\x8b\xef\xb8\x80"},
		{"sqcap", 8851, "\xe2\x8a\x93"},
		{"rightleftarrows", 8644, "\xe2\x87\x84"},
		{"diams", 9830, "\xe2\x99\xa6"},
		{"boxdR", 9554, "\xe2\x95\x92"},
		{"ngeqslant", 10878, "\xe2\xa9\xbe\xcc\xb8"},
		{"boxDR", 9556, "\xe2\x95\x94"},
		{"sext", 10038, "\xe2\x9c\xb6"},
		{"backsim", 8765, "\xe2\x88\xbd"},
		{"nfr", 120107, "\xf0\x9d\x94\xab"},
		{"CloseCurlyDoubleQuote", 8221, "\xe2\x80\x9d"},
		{"npart", 8706, "\xe2\x88\x82\xcc\xb8"},
		{"dharl", 8643, "\xe2\x87\x83"},
		{"NewLine", 10, "\x0a"},
		{"bigotimes", 10754, "\xe2\xa8\x82"},
		{"lAtail", 10523, "\xe2\xa4\x9b"},
		{"frac14", 188, "\xc2\xbc"},
		{"or", 8744, "\xe2\x88\xa8"},
		{"subedot", 10947, "\xe2\xab\x83"},
		{"nmid", 8740, "\xe2\x88\xa4"},
		{"DownArrowUpArrow", 8693, "\xe2\x87\xb5"},
		{"icy", 1080, "\xd0\xb8"},
		{"num", 35, "\x23"},
		{"Gdot", 288, "\xc4\xa0"},
		{"urcrop", 8974, "\xe2\x8c\x8e"},
		{"epsiv", 1013, "\xcf\xb5"},
		{"topcir", 10993, "\xe2\xab\xb1"},
		{"ne", 8800, "\xe2\x89\xa0"},
		{"osol", 8856, "\xe2\x8a\x98"},
		{"amp", 38, "\x26"},
		{"ncap", 10819, "\xe2\xa9\x83"},
		{"Sscr", 119982, "\xf0\x9d\x92\xae"},
		{"sung", 9834, "\xe2\x99\xaa"},
		{"ltri", 9667, "\xe2\x97\x83"},
		{"frac25", 8534, "\xe2\x85\x96"},
		{"DZcy", 1039, "\xd0\x8f"},
		{"RightUpVector", 8638, "\xe2\x86\xbe"},
		{"rsquor", 8217, "\xe2\x80\x99"},
		{"uplus", 8846, "\xe2\x8a\x8e"},
		{"triangleright", 9657, "\xe2\x96\xb9"},
		{"lAarr", 8666, "\xe2\x87\x9a"},
		{"HilbertSpace", 8459, "\xe2\x84\x8b"},
		{"there4", 8756, "\xe2\x88\xb4"},
		{"vscr", 120011, "\xf0\x9d\x93\x8b"},
		{"cirscir", 10690, "\xe2\xa7\x82"},
		{"roarr", 8702, "\xe2\x87\xbe"},
		{"hslash", 8463, "\xe2\x84\x8f"},
		{"supdsub", 10968, "\xe2\xab\x98"},
		{"simg", 10910, "\xe2\xaa\x9e"},
		{"trade", 8482, "\xe2\x84\xa2"},
		{"searrow", 8600, "\xe2\x86\x98"},
		{"DownLeftVector", 8637, "\xe2\x86\xbd"},
		{"FilledSmallSquare", 9724, "\xe2\x97\xbc"},
		{"prod", 8719, "\xe2\x88\x8f"},
		{"oror", 10838, "\xe2\xa9\x96"},
		{"udarr", 8645, "\xe2\x87\x85"},
		{"jsercy", 1112, "\xd1\x98"},
		{"tprime", 8244, "\xe2\x80\xb4"},
		{"bprime", 8245, "\xe2\x80\xb5"},
		{"malt", 10016, "\xe2\x9c\xa0"},
		{"bigcup", 8899, "\xe2\x8b\x83"},
		{"oint", 8750, "\xe2\x88\xae"},
		{"female", 9792, "\xe2\x99\x80"},
		{"omacr", 333, "\xc5\x8d"},
		{"SquareSubsetEqual", 8849, "\xe2\x8a\x91"},
		{"SucceedsEqual", 10928, "\xe2\xaa\xb0"},
		{"plusacir", 10787, "\xe2\xa8\xa3"},
		{"Gcirc", 284, "\xc4\x9c"},
		{"lesdotor", 10883, "\xe2\xaa\x83"},
		{"escr", 8495, "\xe2\x84\xaf"},
		{"THORN", 222, "\xc3\x9e"},
		{"UpArrowBar", 10514, "\xe2\xa4\x92"},
		{"nvrtrie", 8885, "\xe2\x8a\xb5\xe2\x83\x92"},
		{"varkappa", 1008, "\xcf\xb0"},
		{"NotReverseElement", 8716, "\xe2\x88\x8c"},
		{"zdot", 380, "\xc5\xbc"},
		{"ExponentialE", 8519, "\xe2\x85\x87"},
		{"lesseqgtr", 8922, "\xe2\x8b\x9a"},
		{"cscr", 119992, "\xf0\x9d\x92\xb8"},
		{"Dscr", 119967, "\xf0\x9d\x92\x9f"},
		{"lthree", 8907, "\xe2\x8b\x8b"},
		{"Ccedil", 199, "\xc3\x87"},
		{"nge", 8817, "\xe2\x89\xb1"},
		{"UpperLeftArrow", 8598, "\xe2\x86\x96"},
		{"vDash", 8872, "\xe2\x8a\xa8"},
		{"efDot", 8786, "\xe2\x89\x92"},
		{"telrec", 8981, "\xe2\x8c\x95"},
		{"vellip", 8942, "\xe2\x8b\xae"},
		{"nrArr", 8655, "\xe2\x87\x8f"},
		{"ugrave", 249, "\xc3\xb9"},
		{"uring", 367, "\xc5\xaf"},
		{"Bernoullis", 8492, "\xe2\x84\xac"},
		{"nles", 10877, "\xe2\xa9\xbd\xcc\xb8"},
		{"macr", 175, "\xc2\xaf"},
		{"boxuR", 9560, "\xe2\x95\x98"},
		{"clubsuit", 9827, "\xe2\x99\xa3"},
		{"rightarrowtail", 8611, "\xe2\x86\xa3"},
		{"epar", 8917, "\xe2\x8b\x95"},
		{"ltcc", 10918, "\xe2\xaa\xa6"},
		{"twoheadleftarrow", 8606, "\xe2\x86\x9e"},
		{"aleph", 8501, "\xe2\x84\xb5"},
		{"Colon", 8759, "\xe2\x88\xb7"},
		{"vltri", 8882, "\xe2\x8a\xb2"},
		{"quaternions", 8461, "\xe2\x84\x8d"},
		{"rfr", 120111, "\xf0\x9d\x94\xaf"},
		{"Ouml", 214, "\xc3\x96"},
		{"rsh", 8625, "\xe2\x86\xb1"},
		{"emptyv", 8709, "\xe2\x88\x85"},
		{"sqsup", 8848, "\xe2\x8a\x90"},
		{"marker", 9646, "\xe2\x96\xae"},
		{"Efr", 120072, "\xf0\x9d\x94\x88"},
		{"DotEqual", 8784, "\xe2\x89\x90"},
		{"eqsim", 8770, "\xe2\x89\x82"},
		{"NotSucceedsEqual", 10928, "\xe2\xaa\xb0\xcc\xb8"},
		{"primes", 8473, "\xe2\x84\x99"},
		{"times", 215, "\xc3\x97"},
		{"rangd", 10642, "\xe2\xa6\x92"},
		{"rightharpoonup", 8640, "\xe2\x87\x80"},
		{"lrhard", 10605, "\xe2\xa5\xad"},
		{"ape", 8778, "\xe2\x89\x8a"},
		{"varsupsetneq", 8843, "\xe2\x8a\x8b\xef\xb8\x80"},
		{"larrlp", 8619, "\xe2\x86\xab"},
		{"NotPrecedesEqual", 10927, "\xe2\xaa\xaf\xcc\xb8"},
		{"ulcorner", 8988, "\xe2\x8c\x9c"},
		{"acd", 8767, "\xe2\x88\xbf"},
		{"Hacek", 711, "\xcb\x87"},
		{"xuplus", 10756, "\xe2\xa8\x84"},
		{"therefore", 8756, "\xe2\x88\xb4"},
		{"YIcy", 1031, "\xd0\x87"},
		{"Tfr", 120087, "\xf0\x9d\x94\x97"},
		{"Jcirc", 308, "\xc4\xb4"},
		{"LessGreater", 8822, "\xe2\x89\xb6"},
		{"Uring", 366, "\xc5\xae"},
		{"Ugrave", 217, "\xc3\x99"},
		{"rarr", 8594, "\xe2\x86\x92"},
		{"wopf", 120168, "\xf0\x9d\x95\xa8"},
		{"imath", 305, "\xc4\xb1"},
		{"Yopf", 120144, "\xf0\x9d\x95\x90"},
		{"colone", 8788, "\xe2\x89\x94"},
		{"csube", 10961, "\xe2\xab\x91"},
		{"odash", 8861, "\xe2\x8a\x9d"},
		{"olarr", 8634, "\xe2\x86\xba"},
		{"angrt", 8735, "\xe2\x88\x9f"},
		{"NotLeftTriangleBar", 10703, "\xe2\xa7\x8f\xcc\xb8"},
		{"GreaterEqual", 8805, "\xe2\x89\xa5"},
		{"scnap", 10938, "\xe2\xaa\xba"},
		{"pi", 960, "\xcf\x80"},
		{"lesg", 8922, "\xe2\x8b\x9a\xef\xb8\x80"},
		{"orderof", 8500, "\xe2\x84\xb4"},
		{"uacute", 250, "\xc3\xba"},
		{"Barv", 10983, "\xe2\xab\xa7"},
		{"Theta", 920, "\xce\x98"},
		{"leftrightsquigarrow", 8621, "\xe2\x86\xad"},
		{"Atilde", 195, "\xc3\x83"},
		{"cupdot", 8845, "\xe2\x8a\x8d"},
		{"ntriangleright", 8939, "\xe2\x8b\xab"},
		{"measuredangle", 8737, "\xe2\x88\xa1"},
		{"jscr", 119999, "\xf0\x9d\x92\xbf"},
		{"inodot", 305, "\xc4\xb1"},
		{"mopf", 120158, "\xf0\x9d\x95\x9e"},
		{"hkswarow", 10534, "\xe2\xa4\xa6"},
		{"lopar", 10629, "\xe2\xa6\x85"},
		{"thksim", 8764, "\xe2\x88\xbc"},
		{"bkarow", 10509, "\xe2\xa4\x8d"},
		{"rarrfs", 10526, "\xe2\xa4\x9e"},
		{"ntrianglelefteq", 8940, "\xe2\x8b\xac"},
		{"Bscr", 8492, "\xe2\x84\xac"},
		{"topf", 120165, "\xf0\x9d\x95\xa5"},
		{"Uacute", 218, "\xc3\x9a"},
		{"lap", 10885, "\xe2\xaa\x85"},
		{"djcy", 1106, "\xd1\x92"},
		{"bopf", 120147, "\xf0\x9d\x95\x93"},
		{"empty", 8709, "\xe2\x88\x85"},
		{"LeftAngleBracket", 10216, "\xe2\x9f\xa8"},
		{"Imacr", 298, "\xc4\xaa"},
		{"ltcir", 10873, "\xe2\xa9\xb9"},
		{"trisb", 10701, "\xe2\xa7\x8d"},
		{"gjcy", 1107, "\xd1\x93"},
		{"pr", 8826, "\xe2\x89\xba"},
		{"Mu", 924, "\xce\x9c"},
		{"ogon", 731, "\xcb\x9b"},
		{"pertenk", 8241, "\xe2\x80\xb1"},
		{"plustwo", 10791, "\xe2\xa8\xa7"},
		{"Vfr", 120089, "\xf0\x9d\x94\x99"},
		{"ApplyFunction", 8289, "\xe2\x81\xa1"},
		{"Sub", 8912, "\xe2\x8b\x90"},
		{"DoubleLeftRightArrow", 8660, "\xe2\x87\x94"},
		{"Lmidot", 319, "\xc4\xbf"},
		{"nwarrow", 8598, "\xe2\x86\x96"},
		{"angrtvbd", 10653, "\xe2\xa6\x9d"},
		{"fcy", 1092, "\xd1\x84"},
		{"ltlarr", 10614, "\xe2\xa5\xb6"},
		{"CircleMinus", 8854, "\xe2\x8a\x96"},
		{"angmsdab", 10665, "\xe2\xa6\xa9"},
		{"wedgeq", 8793, "\xe2\x89\x99"},
		{"iogon", 303, "\xc4\xaf"},
		{"laquo", 171, "\xc2\xab"},
		{"NestedGreaterGreater", 8811, "\xe2\x89\xab"},
		{"UnionPlus", 8846, "\xe2\x8a\x8e"},
		{"CircleDot", 8857, "\xe2\x8a\x99"},
		{"coloneq", 8788, "\xe2\x89\x94"},
		{"csupe", 10962, "\xe2\xab\x92"},
		{"tcaron", 357, "\xc5\xa5"},
		{"GreaterTilde", 8819, "\xe2\x89\xb3"},
		{"Map", 10501, "\xe2\xa4\x85"},
		{"DoubleLongLeftArrow", 10232, "\xe2\x9f\xb8"},
		{"Uparrow", 8657, "\xe2\x87\x91"},
		{"scy", 1089, "\xd1\x81"},
		{"llarr", 8647, "\xe2\x87\x87"},
		{"rangle", 10217, "\xe2\x9f\xa9"},
		{"sstarf", 8902, "\xe2\x8b\x86"},
		{"InvisibleTimes", 8290, "\xe2\x81\xa2"},
		{"egsdot", 10904, "\xe2\xaa\x98"},
		{"target", 8982, "\xe2\x8c\x96"},
		{"lesges", 10899, "\xe2\xaa\x93"},
		{"curren", 164, "\xc2\xa4"},
		{"yopf", 120170, "\xf0\x9d\x95\xaa"},
		{"frac23", 8532, "\xe2\x85\x94"},
		{"NotSucceedsTilde", 8831, "\xe2\x89\xbf\xcc\xb8"},
		{"napprox", 8777, "\xe2\x89\x89"},
		{"odblac", 337, "\xc5\x91"},
		{"gammad", 989, "\xcf\x9d"},
		{"dscr", 119993, "\xf0\x9d\x92\xb9"},
		{"SupersetEqual", 8839, "\xe2\x8a\x87"},
		{"squf", 9642, "\xe2\x96\xaa"},
		{"Because", 8757, "\xe2\x88\xb5"},
		{"sccue", 8829, "\xe2\x89\xbd"},
		{"KHcy", 1061, "\xd0\xa5"},
		{"Wcirc", 372, "\xc5\xb4"},
		{"uparrow", 8593, "\xe2\x86\x91"},
		{"lessgtr", 8822, "\xe2\x89\xb6"},
		{"thickapprox", 8776, "\xe2\x89\x88"},
		{"lbrksld", 10639, "\xe2\xa6\x8f"},
		{"oslash", 248, "\xc3\xb8"},
		{"NotCupCap", 8813, "\xe2\x89\xad"},
		{"elinters", 9191, "\xe2\x8f\xa7"},
		{"Assign", 8788, "\xe2\x89\x94"},
		{"ClockwiseContourIntegral", 8754, "\xe2\x88\xb2"},
		{"lfisht", 10620, "\xe2\xa5\xbc"},
		{"DownArrow", 8595, "\xe2\x86\x93"},
		{"Zdot", 379, "\xc5\xbb"},
		{"xscr", 120013, "\xf0\x9d\x93\x8d"},
		{"DiacriticalGrave", 96, "\x60"},
		{"DoubleLongLeftRightArrow", 10234, "\xe2\x9f\xba"},
		{"angle", 8736, "\xe2\x88\xa0"},
		{"race", 8765, "\xe2\x88\xbd\xcc\xb1"},
		{"Ascr", 119964, "\xf0\x9d\x92\x9c"},
		{"Xscr", 119987, "\xf0\x9d\x92\xb3"},
		{"acirc", 226, "\xc3\xa2"},
		{"otimesas", 10806, "\xe2\xa8\xb6"},
		{"gscr", 8458, "\xe2\x84\x8a"},
		{"gcy", 1075, "\xd0\xb3"},
		{"angmsdag", 10670, "\xe2\xa6\xae"},
		{"tshcy", 1115, "\xd1\x9b"},
		{"Acy", 1040, "\xd0\x90"},
		{"NotGreaterLess", 8825, "\xe2\x89\xb9"},
		{"dtdot", 8945, "\xe2\x8b\xb1"},
		{"quot", 34, "\x22"},
		{"micro", 181, "\xc2\xb5"},
		{"simplus", 10788, "\xe2\xa8\xa4"},
		{"nsupseteq", 8841, "\xe2\x8a\x89"},
		{"Ufr", 120088, "\xf0\x9d\x94\x98"},
		{"Pr", 10939, "\xe2\xaa\xbb"},
		{"napid", 8779, "\xe2\x89\x8b\xcc\xb8"},
		{"rceil", 8969, "\xe2\x8c\x89"},
		{"boxtimes", 8864, "\xe2\x8a\xa0"},
		{"erarr", 10609, "\xe2\xa5\xb1"},
		{"downdownarrows", 8650, "\xe2\x87\x8a"},
		{"Kfr", 120078, "\xf0\x9d\x94\x8e"},
		{"mho", 8487, "\xe2\x84\xa7"},
		{"scpolint", 10771, "\xe2\xa8\x93"},
		{"vArr", 8661, "\xe2\x87\x95"},
		{"Ccaron", 268, "\xc4\x8c"},
		{"NotRightTriangle", 8939, "\xe2\x8b\xab"},
		{"topbot", 9014, "\xe2\x8c\xb6"},
		{"qopf", 120162, "\xf0\x9d\x95\xa2"},
		{"eogon", 281, "\xc4\x99"},
		{"luruhar", 10598, "\xe2\xa5\xa6"},
		{"gtdot", 8919, "\xe2\x8b\x97"},
		{"Egrave", 200, "\xc3\x88"},
		{"roplus", 10798, "\xe2\xa8\xae"},
		{"Intersection", 8898, "\xe2\x8b\x82"},
		{"Uarr", 8607, "\xe2\x86\x9f"},
		{"dcy", 1076, "\xd0\xb4"},
		{"boxvl", 9508, "\xe2\x94\xa4"},
		{"RightArrowBar", 8677, "\xe2\x87\xa5"},
		{"yuml", 255, "\xc3\xbf"},
		{"parallel", 8741, "\xe2\x88\xa5"},
		{"succneqq", 10934, "\xe2\xaa\xb6"},
		{"bemptyv", 10672, "\xe2\xa6\xb0"},
		{"starf", 9733, "\xe2\x98\x85"},
		{"OverBar", 8254, "\xe2\x80\xbe"},
		{"Alpha", 913, "\xce\x91"},
		{"LeftUpVectorBar", 10584, "\xe2\xa5\x98"},
		{"ufr", 120114, "\xf0\x9d\x94\xb2"},
		{"swarhk", 10534, "\xe2\xa4\xa6"},
		{"GreaterEqualLess", 8923, "\xe2\x8b\x9b"},
		{"sscr", 120008, "\xf0\x9d\x93\x88"},
		{"Pi", 928, "\xce\xa0"},
		{"boxh", 9472, "\xe2\x94\x80"},
		{"frac16", 8537, "\xe2\x85\x99"},
		{"lbrack", 91, "\x5b"},
		{"vert", 124, "\x7c"},
		{"precneqq", 10933, "\xe2\xaa\xb5"},
		{"NotGreaterSlantEqual", 10878, "\xe2\xa9\xbe\xcc\xb8"},
		{"Omega", 937, "\xce\xa9"},
		{"uarr", 8593, "\xe2\x86\x91"},
		{"boxVr", 9567, "\xe2\x95\x9f"},
		{"ruluhar", 10600, "\xe2\xa5\xa8"},
		{"ShortLeftArrow", 8592, "\xe2\x86\x90"},
		{"Qfr", 120084, "\xf0\x9d\x94\x94"},
		{"olt", 10688, "\xe2\xa7\x80"},
		{"nequiv", 8802, "\xe2\x89\xa2"},
		{"fscr", 119995, "\xf0\x9d\x92\xbb"},
		{"rarrhk", 8618, "\xe2\x86\xaa"},
		{"nsqsupe", 8931, "\xe2\x8b\xa3"},
		{"nsubseteq", 8840, "\xe2\x8a\x88"},
		{"numero", 8470, "\xe2\x84\x96"},
		{"emsp14", 8197, "\xe2\x80\x85"},
		{"gl", 8823, "\xe2\x89\xb7"},
		{"ocirc", 244, "\xc3\xb4"},
		{"weierp", 8472, "\xe2\x84\x98"},
		{"boxvL", 9569, "\xe2\x95\xa1"},
		{"RightArrowLeftArrow", 8644, "\xe2\x87\x84"},
		{"Precedes", 8826, "\xe2\x89\xba"},
		{"RightVector", 8640, "\xe2\x87\x80"},
		{"xcup", 8899, "\xe2\x8b\x83"},
		{"angmsdad", 10667, "\xe2\xa6\xab"},
		{"gtrsim", 8819, "\xe2\x89\xb3"},
		{"natural", 9838, "\xe2\x99\xae"},
		{"nVdash", 8878, "\xe2\x8a\xae"},
		{"RightTriangleEqual", 8885, "\xe2\x8a\xb5"},
		{"dscy", 1109, "\xd1\x95"},
		{"leftthreetimes", 8907, "\xe2\x8b\x8b"},
		{"prsim", 8830, "\xe2\x89\xbe"},
		{"Bcy", 1041, "\xd0\x91"},
		{"Chi", 935, "\xce\xa7"},
		{"timesb", 8864, "\xe2\x8a\xa0"},
		{"Del", 8711, "\xe2\x88\x87"},
		{"lmidot", 320, "\xc5\x80"},
		{"RightDownVector", 8642, "\xe2\x87\x82"},
		{"simdot", 10858, "\xe2\xa9\xaa"},
		{"FilledVerySmallSquare", 9642, "\xe2\x96\xaa"},
		{"NotLessSlantEqual", 10877, "\xe2\xa9\xbd\xcc\xb8"},
		{"SucceedsTilde", 8831, "\xe2\x89\xbf"},
		{"duarr", 8693, "\xe2\x87\xb5"},
		{"apE", 10864, "\xe2\xa9\xb0"},
		{"odot", 8857, "\xe2\x8a\x99"},
		{"mldr", 8230, "\xe2\x80\xa6"},
		{"Uarrocir", 10569, "\xe2\xa5\x89"},
		{"nLl", 8920, "\xe2\x8b\x98\xcc\xb8"},
		{"rarrpl", 10565, "\xe2\xa5\x85"},
		{"cir", 9675, "\xe2\x97\x8b"},
		{"blk14", 9617, "\xe2\x96\x91"},
		{"VerticalLine", 124, "\x7c"},
		{"jcy", 1081, "\xd0\xb9"},
		{"filig", 64257, "\xef\xac\x81"},
		{"LongRightArrow", 10230, "\xe2\x9f\xb6"},
		{"beta", 946, "\xce\xb2"},
		{"ccupssm", 10832, "\xe2\xa9\x90"},
		{"supsub", 10964, "\xe2\xab\x94"},
		{"spar", 8741, "\xe2\x88\xa5"},
		{"Tstrok", 358, "\xc5\xa6"},
		{"isinv", 8712, "\xe2\x88\x88"},
		{"rightsquigarrow", 8605, "\xe2\x86\x9d"},
		{"Diamond", 8900, "\xe2\x8b\x84"},
		{"curlyeqsucc", 8927, "\xe2\x8b\x9f"},
		{"ijlig", 307, "\xc4\xb3"},
		{"puncsp", 8200, "\xe2\x80\x88"},
		{"hamilt", 8459, "\xe2\x84\x8b"},
		{"mapstoleft", 8612, "\xe2\x86\xa4"},
		{"Copf", 8450, "\xe2\x84\x82"},
		{"prnsim", 8936, "\xe2\x8b\xa8"},
		{"DotDot", 8412, "\xe2\x83\x9c"},
		{"lobrk", 10214, "\xe2\x9f\xa6"},
		{"twoheadrightarrow", 8608, "\xe2\x86\xa0"},
		{"ngE", 8807, "\xe2\x89\xa7\xcc\xb8"},
		{"cylcty", 9005, "\xe2\x8c\xad"},
		{"sube", 8838, "\xe2\x8a\x86"},
		{"NotEqualTilde", 8770, "\xe2\x89\x82\xcc\xb8"},
		{"Yuml", 376, "\xc5\xb8"},
		{"comp", 8705, "\xe2\x88\x81"},
		{"dotminus", 8760, "\xe2\x88\xb8"},
		{"crarr", 8629, "\xe2\x86\xb5"},
		{"imped", 437, "\xc6\xb5"},
		{"barwedge", 8965, "\xe2\x8c\x85"},
		{"harrcir", 10568, "\xe2\xa5\x88"},
};

#endif
