/*
*  Rubrica
*  file: company-form.h
*
*  
*  Copyright (C) 2000-2005 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _RUBRICA_COMPANY_FORM_H
#define _RUBRICA_COMPANY_FORM_H

#include <gtk/gtk.h>

#include "libral.h"

#include "app.h"
#include "form.h"
#include "form_card.h"
#include "form_info.h"
#include "form_address.h"
#include "form_contact.h"
#include "form_net.h"
#include "form_phone.h"


typedef struct _CompanyForm {
  RubricaApp  *app;

  GtkWidget   *dialog;
  
  RubricaFormCard    *card;
  RubricaFormInfo    *info;
  RubricaFormAddress *address;
  RubricaFormNet     *net;
  RubricaFormPhone   *tel;
  GtkWidget          *notes;
} CompanyDialog;


CompanyDialog* rubrica_company_dialog_new        (RubricaApp* app);

void           rubrica_company_run_add_dialog    (CompanyDialog* form);
RCompanyCard*  rubrica_company_run_modify_dialog (CompanyDialog* form);

RCompanyCard*  rubrica_company_extract_card_data (CompanyDialog* form);
void           rubrica_company_display_card_data (CompanyDialog* form, 
						  RCard* card);

#endif
