require 'spec_helper'

describe Elasticsearch::DSL::Search::Queries::SpanOr do

  describe '#to_hash' do

    let(:search) do
      described_class.new
    end

    it 'can be converted to a hash' do
      expect(search.to_hash).to eq(span_or: {})
    end
  end

  context 'when options methods are called' do

    let(:search) do
      described_class.new
    end

    [ 'clauses' ].each do |option|

      describe "##{option}" do

        before do
          search.send(option, 'bar')
        end

        it 'applies the option' do
          expect(search.to_hash[:span_or][option.to_sym]).to eq('bar')
        end
      end
    end
  end

  describe '#initialize' do

    context 'when a block is provided' do

      let(:search) do
        described_class.new do
          clauses 'bar'
        end
      end

      it 'executes the block' do
        expect(search.to_hash[:span_or][:clauses]).to eq('bar')
      end
    end
  end
end
