#! /usr/bin/env python

"""ex-email.py - Delivering the alarm by email

This file contains a more involved example for
SandUhr's CORBA support.  It implements and uses an
AlarmAction object, which delivers the alarm per email.

To use this example, you must adjust the variables
EMAIL and SENDMAIL to fit your local setup.  If you
run this script it should open a timer window and
start to sleep.  Until 60 seconds it should send an
email and then quit."""

EMAIL = "Addressee <some@email.address>"
SENDMAIL = "/usr/sbin/sendmail"

import os
import CORBA, oaf
import SandUhr, SandUhr__POA

orb = oaf.init()

class SendMailAlarm(SandUhr__POA.AlarmAction):
    def __init__(self):
        self.NeedsPopup = CORBA.FALSE

    def Attach(self, timer):
        pass

    def Detach(self, timer):
        orb.shutdown(1)

    def Deliver(self, timespec, message):
        p = os.popen("%s -t" % SENDMAIL, "w")
        p.write("To: %s\n" % EMAIL)
        p.write("Subject: SandUhr: %s\n" % message)
        p.write("\n") # blank line separating headers from body
        p.write("A SandUhr timer has expired.\n")
        p.write("  alarm message: %s\n" % message)
        p.write("  alarm time: %s\n" % timespec)
        sts = p.close()
        if sts:
            print "Sendmail exit status", sts

poa = orb.resolve_initial_references("RootPOA")
alarm = SendMailAlarm()._this()
poa._get_the_POAManager().activate()

factory = oaf.activate("repo_ids.has('IDL:SandUhr/TimerFactory:1.0')",[])
timer = factory.CreateTimer ("+60s", "The example timer has reached its time")
timer.Alarm = alarm

orb.run()
