/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd.basic;

import com.thaiopensource.xml.util.Name;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wildcard {
    private final boolean positive;
    private final Set<String> namespaces;
    private final Set<Name> excludedNames;

    public Wildcard(boolean bl, Set<String> set, Set<Name> set2) {
        this.positive = bl;
        this.namespaces = Collections.unmodifiableSet(set);
        this.excludedNames = Collections.unmodifiableSet(set2);
    }

    public boolean isPositive() {
        return this.positive;
    }

    public Set<String> getNamespaces() {
        return this.namespaces;
    }

    public Set<Name> getExcludedNames() {
        return this.excludedNames;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Wildcard)) {
            return false;
        }
        Wildcard wildcard = (Wildcard)object;
        return this.positive == wildcard.positive && ((Object)this.namespaces).equals(wildcard.namespaces) && ((Object)this.excludedNames).equals(wildcard.excludedNames);
    }

    public int hashCode() {
        return ((Object)this.namespaces).hashCode() ^ ((Object)this.excludedNames).hashCode();
    }

    public boolean contains(Name name) {
        return this.namespaces.contains(name.getNamespaceUri()) == this.positive && !this.excludedNames.contains(name);
    }

    public static Wildcard union(Wildcard wildcard, Wildcard wildcard2) {
        boolean bl;
        HashSet<String> hashSet = new HashSet<String>();
        if (wildcard.isPositive() && wildcard2.isPositive()) {
            bl = true;
            hashSet.addAll(wildcard.getNamespaces());
            hashSet.addAll(wildcard2.getNamespaces());
        } else {
            bl = false;
            if (!wildcard.isPositive() && !wildcard2.isPositive()) {
                hashSet.addAll(wildcard.getNamespaces());
                hashSet.retainAll(wildcard2.getNamespaces());
            } else if (!wildcard.isPositive()) {
                hashSet.addAll(wildcard.getNamespaces());
                hashSet.removeAll(wildcard2.getNamespaces());
            } else {
                hashSet.addAll(wildcard2.getNamespaces());
                hashSet.removeAll(wildcard.getNamespaces());
            }
        }
        HashSet<Name> hashSet2 = new HashSet<Name>();
        Wildcard.addExcludedNames(hashSet2, wildcard, wildcard2);
        Wildcard.addExcludedNames(hashSet2, wildcard2, wildcard);
        return new Wildcard(bl, hashSet, hashSet2);
    }

    private static void addExcludedNames(Set<Name> set, Wildcard wildcard, Wildcard wildcard2) {
        for (Name name : wildcard.getExcludedNames()) {
            if (wildcard2.contains(name)) continue;
            set.add(name);
        }
    }
}

