// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2010, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================


#ifndef SEQAN_HEADER_STATISTICS_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_STATISTICS_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// MarkovModel

template <typename TAlphabet, typename TFloat , typename TSpec > class MarkovModel;       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_markov_model.h"(120)

} //namespace seqan


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// TDnaAlphabet

typedef Dna TDnaAlphabet;       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_base.h"(328)

//____________________________________________________________________________
// TDnaSequence

typedef String<TDnaAlphabet> TDnaSequence;       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_base.h"(329)

} //namespace seqan


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// _addReveseComplements

template <typename TAlphabet> void _addReveseComplements(StringSet<String<TAlphabet> > &stringSet);       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_base.h"(314)

//____________________________________________________________________________
// _computeExpectation

template <typename TAlphabet, typename TFloat, typename TSpec> TFloat _computeExpectation(MarkovModel<TAlphabet, TFloat, TSpec> &mm, StringSet<String<TAlphabet> > &W, unsigned int n);       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_base.h"(139)

//____________________________________________________________________________
// _computeInverseMatrix

template <typename TValue> Matrix<TValue,2> _computeInverseMatrix(Matrix<TValue,2> &matrix);       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_markov_model.h"(547)

//____________________________________________________________________________
// _computeVariance

template <typename TFloat, typename TAlphabet, typename TSpec> TFloat _computeVariance( StringSet<String<TAlphabet> > W, StringSet<String<TAlphabet> > &X, MarkovModel<TAlphabet, TFloat, TSpec> &M, TFloat &E);       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_base.h"(169)

//____________________________________________________________________________
// _lubksb

template <typename TValue> void _lubksb(Matrix<TValue,2> &a, String<TValue> &indx, String<TValue> &b);       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_markov_model.h"(692)

//____________________________________________________________________________
// _ludcmp

template <typename TValue> String<TValue> _ludcmp(Matrix<TValue,2> &result);       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_markov_model.h"(599)

//____________________________________________________________________________
// _numOccurrences

template <typename TAlgorithm, typename TFloat, typename TAlphabet> void _numOccurrences(TFloat &nW, String<TAlphabet> &haystack, StringSet<String<TAlphabet> > &needle, TAlgorithm const &);       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_base.h"(107)

//____________________________________________________________________________
// _overlapExpectation

template <typename TFloat, typename TAlphabet, typename TSpec> TFloat _overlapExpectation(StringSet<String<TAlphabet> > W, MarkovModel<TAlphabet, TFloat, TSpec> &M, unsigned int n);       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_base.h"(274)

//____________________________________________________________________________
// _zscore

template <typename TAlgorithm, typename TFloat, typename TStringSet, typename TAlphabet, typename TSpec> TFloat _zscore(TStringSet W, TStringSet& X, MarkovModel<TAlphabet, TFloat, TSpec> & M, TAlgorithm const &);       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_base.h"(63)

//____________________________________________________________________________
// buildMarkovModel

template <typename TAlphabet, typename TFloat, typename TSpec> void buildMarkovModel(MarkovModel<TAlphabet, TFloat, TSpec> &mm, StringSet<String<TAlphabet > > &stringSet);       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_markov_model.h"(738)
template <typename TAlphabet, typename TFloat, typename TSpec> void buildMarkovModel(MarkovModel<TAlphabet, TFloat, TSpec> &mm, StringSet<String<TAlphabet > > const &stringSet);       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_markov_model.h"(747)

//____________________________________________________________________________
// emittedProbability

template <typename TAlphabet, typename TFloat, typename TSpec> TFloat emittedProbability(MarkovModel<TAlphabet, TFloat, TSpec> & mm, StringSet<String<TAlphabet > > & stringSet);       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_markov_model.h"(778)
template <typename TAlphabet, typename TFloat, typename TSpec> TFloat emittedProbability(MarkovModel<TAlphabet, TFloat, TSpec> & mm, String<TAlphabet> &string);       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_markov_model.h"(785)
template <typename TAlphabet, typename TFloat, typename TSpec, typename TString, typename TSetSpec> TFloat emittedProbability(MarkovModel<TAlphabet, TFloat, TSpec> & mm, StringSet<TString, TSetSpec> const &stringSet);       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_markov_model.h"(793)
template <typename TAlphabet, typename TFloat, typename TSpec, typename TString> TFloat emittedProbability(MarkovModel<TAlphabet, TFloat, TSpec> & mm, TString const &string);       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_markov_model.h"(800)

//____________________________________________________________________________
// ensureAuxMatrices

template <typename TAlphabet, typename TFloat, typename TSpec> void ensureAuxMatrices(MarkovModel<TAlphabet, TFloat, TSpec> & mm );       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_markov_model.h"(824)

//____________________________________________________________________________
// expectation

template <typename TAlphabet, typename TFloat, typename TSpec> TFloat expectation(StringSet<String<TAlphabet> > & W, StringSet<String<TAlphabet> > &X, MarkovModel<TAlphabet, TFloat, TSpec> &M);       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_base.h"(487)

//____________________________________________________________________________
// read

template <typename TAlphabet, typename TFloat, typename TSpec> void read(FILE *file, MarkovModel<TAlphabet, TFloat, TSpec> & mm );       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_markov_model.h"(818)

//____________________________________________________________________________
// setMarkovModel

template <typename TAlphabet, typename TFloat, typename TSpec> void setMarkovModel(MarkovModel<TAlphabet, TFloat, TSpec> & mm, Matrix<TFloat,2> &iTransition);       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_markov_model.h"(759)
template <typename TAlphabet, typename TFloat, typename TSpec> void setMarkovModel(MarkovModel<TAlphabet, TFloat, TSpec> & mm, Matrix<TFloat,2> &iTransition, String<TFloat> &iStationaryDistribution);       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_markov_model.h"(769)

//____________________________________________________________________________
// variance

template <typename TFloat, typename TAlphabet, typename TSpec> TFloat variance(StringSet<String<TAlphabet> > &W, StringSet<String<TAlphabet> >& X, MarkovModel<TAlphabet, TFloat, TSpec> & M);       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_base.h"(426)
template <typename TFloat, typename TSpec> TFloat variance(StringSet<String<Dna> > W, StringSet<String<Dna> > &X, MarkovModel<Dna, TFloat, TSpec> & M);       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_base.h"(435)

//____________________________________________________________________________
// write

template <typename TAlphabet, typename TFloat, typename TSpec> void write(FILE *file, MarkovModel<TAlphabet, TFloat, TSpec> & mm );       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_markov_model.h"(809)

//____________________________________________________________________________
// zscore

template <typename TAlgorithm, typename TFloat, typename TSpec, typename TStringSet, typename TAlphabet> TFloat zscore(TStringSet W, TStringSet &X, MarkovModel<TAlphabet, TFloat, TSpec> &M, TAlgorithm const & algorithmTag);       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_base.h"(349)
template <typename TAlgorithm, typename TFloat, typename TSpec, typename TDnaSequence> TFloat zscore(StringSet<TDnaSequence> W, StringSet<TDnaSequence> &X, MarkovModel<Dna, TFloat, TSpec> &M, TAlgorithm const &);       	// "/Volumes/weese/sandbox/seqan-1.3.1/seqan/statistics/statistics_base.h"(356)

} //namespace seqan

#endif

