8.1 Listes

# Listes

Dans cette section, nous allons voir une structure de données qui est 
très utile - la liste. Nous l'avons rencontrée brièvement auparavant 
dans la section sur la randomisation quand nous choisissions 
aléatoirement des notes à jouer dans une liste :

```
play choose([50, 55, 62])
```

Dans cette section, nous allons explorer l'utilisation des listes 
également pour représenter des accords et des gammes. En premier lieu, 
récapitulons comment nous jouerions un accord. Souvenez-vous que si 
nous n'utilisons pas `sleep`, les sons arrivent tous au même moment :

```
play 52
play 55
play 59
```

Regardons une autre façon d'écrire ce code.

## Jeu d'une liste

Une option est de placer toutes les notes dans une liste : `[52, 55, 59]`.
Notre sympathique fonction `play` est assez évoluée pour savoir 
comment jouer une liste de notes. Essayez-le :

```
play [52, 55, 59]
```

Ooh, c'est déjà plus agréable à lire. Jouer une liste de notes ne 
vous empêche pas d'utiliser n'importe quel paramètre des spécifications :

```
play [52, 55, 59], amp: 0.3
```

Bien sûr, vous pouvez aussi utiliser les noms traditionnels des notes 
(en notation anglaise) à la place des nombres de la norme MIDI :

```
play [:E3, :G3, :B3]
```


Maintenant, ceux qui sont assez chanceux pour avoir étudié quelques 
notions de solfège, pourraient reconnaître l'accord de *Mi mineur* 
joué à la 3ème octave.

## Accès à une liste

Une autre caractéristique très utile d'une liste est d'en extraire de 
l'information. Ceci peut paraître étrange, mais ce n'est pas plus 
compliqué que de tourner les pages d'un livre jusqu'à la page 23. Avec 
une liste, vous diriez : quel est l'élément à l'index 23 ? La seule 
chose étrange est qu'en programmation, les index commencent 
généralement à 0 et non pas 1. 

Avec les index de liste, nous ne comptons pas 1, 2, 3... mais 0, 1, 2...

Regardons ceci en un peu plus de détails. Jetez un œil sur cette liste :

```
[52, 55, 59]
```

Il n'y a rien là de particulièrement effrayant. Maintenant, 
quel est le second élément de la liste ? Oui, bien sûr, c'est `55`. 
C'était facile. Regardons si nous pouvons obtenir la réponse de 
l'ordinateur :

```
puts [52, 55, 59][1]
```

OK, ça semble un peu bizarre si vous n'avez jamais vu quelque chose de 
la sorte auparavant. Faites-moi confiance toutefois, ce n'est pas trop 
dur. Il y a trois parties dans la ligne ci-dessus : le mot `puts`, 
notre liste `52, 55, 59` et notre index `[1]`. En premier, nous disons 
`puts` parce que nous voulons que Sonic Pi nous affiche la réponse dans 
le panneau "trace". Ensuite, nous lui donnons notre liste, et enfin notre 
index qui demande le second élément. Nous devons encadrer notre index 
avec des crochets et parce que le compte commence à 0, l'index pour le 
second élément est `1`. Regardez :

```
# index :  0   1   2
          [52, 55, 59]
```

Essayez d'exécuter le code `puts [52, 55, 59][1]` et vous verrez `55` 
apparaître dans le panneau "trace". Changez l'index `1` par d'autres 
valeurs, essayez des listes plus longues et pensez à la façon dont 
vous pourriez utiliser une liste dans votre prochaine improvisation 
avec du code. Par exemple, quelles structures musicales pourraient être 
représentées par une série de nombres...




