///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// http://www.cooldevtools.com
// $Id: MimeDecoder.h 272 2007-01-06 19:37:27Z brian $
//
// Copyright (C) 2007 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//    http://www.cooldevtools.com/qpl.html
//

#ifndef _MimeDecoder_h
#define _MimeDecoder_h

#include "Buffer.h"
class AbstractCharReader;
class AbstractMultiLineString;
class MultiLineString;
class MessageHeader;
class MessageHeaderList;

class MimeDecoder
{
public:
  bool isQuotedPrintable(const CRef<AbstractMultiLineString> &contentTransferEncoding);
  bool isBase64(const CRef<AbstractMultiLineString> &contentTransferEncoding);
  CRef<AbstractMultiLineString> decodeText(const MessageHeaderList *headers,
                                                  const CRef<AbstractMultiLineString> &body);

  CRef<AbstractMultiLineString> unquoteString(const CRef<AbstractMultiLineString> &messageBody,
                                                     bool convert_underscores = false);
  CRef<AbstractMultiLineString> decodeString(const CRef<AbstractMultiLineString> &messageBody);
  void decodeString(AbstractCharReader *reader,
                    string &decoded_string);
  CRef<AbstractMultiLineString> decodeHeaderString(const CRef<AbstractMultiLineString> &body);

  void decodeData(const CRef<AbstractMultiLineString> &messageBody,
                  Buffer<unsigned char> &decoded_data);
  void decodeData(AbstractCharReader *reader,
                  Buffer<unsigned char> &decoded_data);

private:
  void addLineToString(MultiLineString *answer,
                       const string &new_line,
                       const string &orig_line,
                       bool lineChanged);
};

#endif

