/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.cdf.record;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import uk.ac.bristol.star.cdf.CdfFormatException;
import uk.ac.bristol.star.cdf.record.BitExpandInputStream;
import uk.ac.bristol.star.cdf.record.RunLengthInputStream;

public abstract class Compression {
    public static final Compression NONE = new Compression("NONE"){

        public InputStream uncompressStream(InputStream inputStream) {
            return inputStream;
        }
    };
    public static final Compression RLE = new Compression("RLE"){

        public InputStream uncompressStream(InputStream inputStream) throws IOException {
            return new RunLengthInputStream(inputStream, 0);
        }
    };
    public static final Compression HUFF = new Compression("HUFF"){

        public InputStream uncompressStream(InputStream inputStream) throws IOException {
            return new BitExpandInputStream.HuffmanInputStream(inputStream);
        }
    };
    public static final Compression AHUFF = new Compression("AHUFF"){

        public InputStream uncompressStream(InputStream inputStream) throws IOException {
            return new BitExpandInputStream.AdaptiveHuffmanInputStream(inputStream);
        }
    };
    public static final Compression GZIP = new Compression("GZIP"){

        public InputStream uncompressStream(InputStream inputStream) throws IOException {
            return new GZIPInputStream(inputStream);
        }
    };
    private final String name_;

    protected Compression(String string) {
        this.name_ = string;
    }

    public abstract InputStream uncompressStream(InputStream var1) throws IOException;

    public String getName() {
        return this.name_;
    }

    public static Compression getCompression(int n) throws CdfFormatException {
        switch (n) {
            case 0: {
                return NONE;
            }
            case 1: {
                return RLE;
            }
            case 2: {
                return HUFF;
            }
            case 3: {
                return AHUFF;
            }
            case 5: {
                return GZIP;
            }
        }
        throw new CdfFormatException("Unknown compression format cType=" + n);
    }
}

