/*
 * Decompiled with CFR 0.152.
 */
package adql.db;

import adql.db.DBTable;
import adql.db.SearchTableApi;
import adql.query.IdentifierField;
import adql.query.from.ADQLTable;
import cds.utils.TextualSearchList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchTableList
extends TextualSearchList<DBTable>
implements SearchTableApi {
    private static final long serialVersionUID = 1L;
    private boolean distinct = false;

    public SearchTableList() {
        super(new DBTableKeyExtractor());
    }

    public SearchTableList(Collection<? extends DBTable> collection) {
        super(collection, new DBTableKeyExtractor());
    }

    public SearchTableList(int initialCapacity) {
        super(initialCapacity, new DBTableKeyExtractor());
    }

    public final boolean isDistinct() {
        return this.distinct;
    }

    public final void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    @Override
    public SearchTableApi getCopy() {
        return new SearchTableList(this);
    }

    public List<DBTable> search(String tableName) {
        return this.get(tableName);
    }

    public final List<DBTable> search(String catalog, String schema, String table) {
        return this.search(catalog, schema, table, (byte)0);
    }

    @Override
    public List<DBTable> search(ADQLTable table) {
        return this.search(table.getCatalogName(), table.getSchemaName(), table.getTableName(), table.getCaseSensitive());
    }

    public List<DBTable> search(String catalog, String schema, String table, byte caseSensitivity) {
        List<DBTable> tmpResult = this.get(table, IdentifierField.TABLE.isCaseSensitive(caseSensitivity));
        if (schema != null) {
            ArrayList<DBTable> result = new ArrayList<DBTable>();
            for (DBTable match : tmpResult) {
                if (match.getADQLSchemaName() == null || (!IdentifierField.SCHEMA.isCaseSensitive(caseSensitivity) ? !match.getADQLSchemaName().equalsIgnoreCase(schema) : !match.getADQLSchemaName().equals(schema)) || catalog != null && (match.getADQLCatalogName() == null || (IdentifierField.CATALOG.isCaseSensitive(caseSensitivity) ? !match.getADQLCatalogName().equals(catalog) : !match.getADQLCatalogName().equalsIgnoreCase(catalog)))) continue;
                result.add(match);
            }
            return result;
        }
        return tmpResult;
    }

    @Override
    public boolean add(DBTable item) {
        if (this.distinct && this.contains(item)) {
            return false;
        }
        return super.add(item);
    }

    private static class DBTableKeyExtractor
    implements TextualSearchList.KeyExtractor<DBTable> {
        private DBTableKeyExtractor() {
        }

        @Override
        public String getKey(DBTable obj) {
            if (obj.isCaseSensitive()) {
                return obj.getADQLName();
            }
            return obj.getADQLName().toLowerCase();
        }
    }
}

