/* ====================================================================
 * Copyright (c) 2007,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _PROJECTSORTER_TEST_H
#define _PROJECTSORTER_TEST_H

// cppunit
#include <cppunit/TestFixture.h>
#include <cppunit/extensions/HelperMacros.h>

// sc
#include "subcommander/ProjectTypes.h"
class Uuid;

class ProjectSorterTest : public CppUnit::TestCase
{
  CPPUNIT_TEST_SUITE( ProjectSorterTest );
  CPPUNIT_TEST( testCleanupSortPosition );
  CPPUNIT_TEST( testMove );
  CPPUNIT_TEST_SUITE_END(); 

public:
  void setUp();
  void tearDown();

  // Tests
  void testCleanupSortPosition();
  void testMove();

private:
  Projects _projects;

  // move
  Uuid*    _uuid1;
  Uuid*    _uuid6;
};

#endif // _PROJECTSORTER_TEST_H
