from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


ElementTree = _Mock()

add_anchor = _Mock()

add_prompts = _Mock()

ascii_only = _Mock()

comment_lines = _Mock()

files_url_pattern = _Mock()

get_lines = _Mock()

html2text = _Mock()

ipython2python = _Mock()

markdown_url_pattern = _Mock()

os = _Mock()

path2url = _Mock()

posix_path = _Mock()

py3compat = _Mock()

quote = _Mock()

re = _Mock()

strip_dollars = _Mock()

strip_files_prefix = _Mock()

textwrap = _Mock()

wrap_text = _Mock()



class InteractiveShell(_Mock):
  pass
  default_user_namespaces = True

