
[//000000001]: # (base32::core \- Base32 encoding)
[//000000002]: # (Generated from file 'base32core\.man' by tcllib/doctools with format 'markdown')
[//000000003]: # (Public domain)
[//000000004]: # (base32::core\(n\) 0\.2 tcllib "Base32 encoding")

<hr> [ <a href="../../../../toc.md">Main Table Of Contents</a> &#124; <a
href="../../../toc.md">Table Of Contents</a> &#124; <a
href="../../../../index.md">Keyword Index</a> &#124; <a
href="../../../../toc0.md">Categories</a> &#124; <a
href="../../../../toc1.md">Modules</a> &#124; <a
href="../../../../toc2.md">Applications</a> ] <hr>

# NAME

base32::core \- Expanding basic base32 maps

# <a name='toc'></a>Table Of Contents

  - [Table Of Contents](#toc)

  - [Synopsis](#synopsis)

  - [Description](#section1)

  - [API](#section2)

  - [Bugs, Ideas, Feedback](#section3)

  - [Keywords](#keywords)

  - [Category](#category)

  - [Copyright](#copyright)

# <a name='synopsis'></a>SYNOPSIS

package require Tcl 8\.5 9  
package require base32::core ?0\.2?  

[__::base32::core::define__ *map* *forwvar* *backwvar* *ivar*](#1)  
[__::base32::core::valid__ *string* *pattern* *mvar*](#2)  

# <a name='description'></a>DESCRIPTION

This package provides generic commands for the construction of full base32
mappings from a basic mapping listing just the codes and associated characters\.
The full mappings, regular and inverse, created here map to and from bit
sequences, and also handle the partial mappings at the end of a string\.

This is in essence an internal package to be used by implementors of a base32
en\- and decoder\. A regular user has no need of this package at all\.

# <a name='section2'></a>API

  - <a name='1'></a>__::base32::core::define__ *map* *forwvar* *backwvar* *ivar*

    This command computes full forward and backward \(inverse\) mappings from the
    basic *map* and stores them in the variables named by *forwvar* and
    *backwvar* resp\. It also constructs a regexp pattern for the detection of
    invalid characters in supposedly base32 encoded input and stores it in the
    variable named by *ivar*\.

  - <a name='2'></a>__::base32::core::valid__ *string* *pattern* *mvar*

    This command checks if the input *string* is a valid base32 encoded
    string, based on the *pattern* of invalid characters as generated by
    __::base32::core::define__, and some other general rules\.

    The result of the command is a boolean flag\. Its value is __True__ for a
    valid *string*, and __False__ otherwise\. In the latter case an error
    message describing the problem with the input is stored into the variable
    named by *mvar*\. The variable is not touched if the input was found to be
    valid\.

    The rules checked by the command, beyond rejection of bad characters, are:

      1. The length of the input is not a multiple of eight,

      1. The padding appears not at the end of input, but in the middle,

      1. The padding has not of length six, four, three, or one characters,

# <a name='section3'></a>Bugs, Ideas, Feedback

This document, and the package it describes, will undoubtedly contain bugs and
other problems\. Please report such in the category *base32* of the [Tcllib
Trackers](http://core\.tcl\.tk/tcllib/reportlist)\. Please also report any ideas
for enhancements you may have for either package and/or documentation\.

When proposing code changes, please provide *unified diffs*, i\.e the output of
__diff \-u__\.

Note further that *attachments* are strongly preferred over inlined patches\.
Attachments can be made by going to the __Edit__ form of the ticket
immediately after its creation, and then using the left\-most button in the
secondary navigation bar\.

# <a name='keywords'></a>KEYWORDS

[base32](\.\./\.\./\.\./\.\./index\.md\#base32)

# <a name='category'></a>CATEGORY

Text processing

# <a name='copyright'></a>COPYRIGHT

Public domain
