## TFSA-2022-169: `CHECK` failure in `SobolSample` via missing validation

### CVE Number
CVE-2022-35935


### Impact
Another instance of CVE-2022-35935, where `SobolSample` is vulnerable to a denial of service via assumed scalar inputs, was found and fixed.
```python
import tensorflow as tf
tf.raw_ops.SobolSample(dim=tf.constant([1,0]), num_results=tf.constant([1]), skip=tf.constant([1]))
```

### Patches
We have patched the issue in GitHub commits [c65c67f88ad770662e8f191269a907bf2b94b1bf](https://github.com/tensorflow/tensorflow/commit/c65c67f88ad770662e8f191269a907bf2b94b1bf) and [02400ea266bd811fc016a848445de1bbff3a23a0](https://github.com/tensorflow/tensorflow/commit/02400ea266bd811fc016a848445de1bbff3a23a0)

The fix will be included in TensorFlow 2.11. We will also cherrypick both commits on TensorFlow 2.10.1, 2.9.3, and TensorFlow 2.8.4, as these are also affected and still in supported range. TensorFlow 2.7.4 will have the first commit cherrypicked.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by:
- Kang Hong Jin from Singapore Management University
- Neophytos Christou, Secure Systems Labs, Brown University
- 刘力源, Information System & Security and Countermeasures Experiments Center, Beijing Institute of Technology
- Pattarakrit Rattankul
