/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.sf;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import net.tinyos.packet.BuildSource;
import net.tinyos.packet.PacketListenerIF;
import net.tinyos.packet.PhoenixError;
import net.tinyos.packet.PhoenixSource;
import net.tinyos.sf.SFClient;
import net.tinyos.sf.SerialForwarder;
import net.tinyos.util.Messenger;

public class SFListen
extends Thread
implements PacketListenerIF,
PhoenixError {
    PhoenixSource source;
    private ServerSocket serverSocket;
    private Vector clients = new Vector();
    private SerialForwarder sf;

    public SFListen(SerialForwarder serialForwarder) {
        this.sf = serialForwarder;
    }

    public void error(IOException iOException) {
        if (iOException.getMessage() != null) {
            this.sf.message(iOException.getMessage());
        }
        this.sf.message(this.source.getPacketSource().getName() + " died - restarting");
        try {
            SFListen.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.sf.verbose.message("Listening to " + this.sf.motecom);
            this.source = BuildSource.makePhoenix(this.sf.motecom, (Messenger)this.sf.verbose);
            if (this.source == null) {
                this.sf.message("Invalid source " + this.sf.motecom + ", pick one of:");
                this.sf.message(BuildSource.sourceHelp());
                return;
            }
            this.source.setPacketErrorHandler(this);
            this.source.registerPacketListener(this);
            this.source.start();
            try {
                this.serverSocket = new ServerSocket(this.sf.serverPort);
            }
            catch (Exception exception) {
                this.sf.message("Could not listen on port: " + this.sf.serverPort);
                this.source.shutdown();
                this.cleanup();
                this.sf.verbose.message("--------------------------");
                return;
            }
            this.sf.verbose.message("Listening for client connections on port " + this.sf.serverPort);
            try {
                while (true) {
                    Socket socket = this.serverSocket.accept();
                    SFClient sFClient = new SFClient(socket, this.sf, this);
                    this.clients.add(sFClient);
                    sFClient.start();
                }
            }
            catch (IOException iOException) {
                this.cleanup();
                this.sf.verbose.message("--------------------------");
            }
        }
        finally {
            this.cleanup();
            this.sf.verbose.message("--------------------------");
        }
    }

    private void cleanup() {
        this.shutdownAllSFClients();
        this.sf.verbose.message("Closing source");
        if (this.source != null) {
            this.source.shutdown();
        }
        this.sf.verbose.message("Closing socket");
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.sf.listenServerStopped();
    }

    private void shutdownAllSFClients() {
        this.sf.verbose.message("Shutting down all client connections");
        while (this.clients.size() != 0) {
            SFClient sFClient = (SFClient)this.clients.firstElement();
            sFClient.shutdown();
            try {
                sFClient.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public void removeSFClient(SFClient sFClient) {
        this.clients.remove(sFClient);
    }

    public void packetReceived(byte[] byArray) {
        this.sf.incrementPacketsRead();
    }

    public void shutdown() {
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {
            this.sf.debug.message("shutdown error " + iOException);
        }
    }
}

