import cairo

from gi.repository import Gtk
from gi.repository import Gdk
from gi.repository import GObject
from gi.repository import GdkPixbuf

GObject.threads_init()


class CellTestRenderer(Gtk.CellRendererText):
    protected = GObject.property(type=bool, default=False)
    verified = GObject.property(type=bool, default=False)
    favorited = GObject.property(type=bool, default=False)

    def __init__(self, layout):
        GObject.GObject.__init__(self)
        self._layout = layout
        self.accumulative_width = 0

    def _render_icon(self, cr, cell_area, xpad, ypad):
        self.accumulative_width = 0
        icon = GdkPixbuf.Pixbuf.new_from_file('/tmp/mark-reposted.png')
        x = cell_area.x
        y = cell_area.y + ypad
        Gdk.cairo_set_source_pixbuf(cr, icon, x, y)
        self.accumulative_width += icon.get_width()
        del icon
        cr.paint()
        return

    def _render_username(self, text, context, cr, cell_area, layout, xpad, ypad):
        y = cell_area.y + ypad
        extent = cr.text_extents(text)
        x = cell_area.x + 2 + xpad + self.accumulative_width
        self.accumulative_width += extent[4] + (extent[4]/2)
        layout.set_markup(text, -1)
        #layout.set_markup('ola bale', -1)

        context.save()
        Gtk.render_layout(context, cr, x, y, layout)
        context.restore()
        return

    def _render_protected(self, cr, cell_area, xpad, ypad):
        icon = GdkPixbuf.Pixbuf.new_from_file('/tmp/mark-protected.png')
        x = cell_area.x + xpad + self.accumulative_width
        y = cell_area.y + ypad
        Gdk.cairo_set_source_pixbuf(cr, icon, x, y)
        del icon
        cr.paint()
        return

    def _render_verified(self, cr, cell_area, xpad, ypad):
        icon = GdkPixbuf.Pixbuf.new_from_file('/tmp/mark-verified.png')
        x = cell_area.x + xpad + self.accumulative_width
        y = cell_area.y + ypad
        Gdk.cairo_set_source_pixbuf(cr, icon, x, y)
        del icon
        cr.paint()
        return

    def do_set_property(self, pspec, value):
        setattr(self, pspec.name, value)

    def do_get_property(self, pspec):
        return getattr(self, pspec.name)

    def do_get_preferred_height_for_width(self, treeview, width):
        return 56, width

    def do_render(self, cr, widget, bg_area, cell_area, flags):
        context = widget.get_style_context()
        xpad = self.get_property('xpad')
        ypad = self.get_property('ypad')
        layout = self._layout
        text = self.get_property('text')
        print cell_area.width

        context.save()

        self._render_icon(cr, cell_area, xpad, ypad)
        self._render_username(text, context, cr, cell_area, layout, xpad, ypad)
        if self.get_property('protected'):
            self._render_protected(cr, cell_area, xpad, ypad)

        if self.get_property('verified'):
            self._render_verified(cr, cell_area, xpad, ypad)

        context.restore()
        return

class AvatarTest(Gtk.Alignment):
    def __init__(self):
        Gtk.Alignment.__init__(self)

    def set_image(self, image):
        context = self.get_window().cairo_create()
        icon = GdkPixbuf.Pixbuf.new_from_file('/tmp/arch.png')
        context.set_source_pixbuf(icon)
        del icon

class AvatarTest2(Gtk.DrawingArea):
    def __init__(self):
        Gtk.DrawingArea.__init__(self)
        self.connect('draw', self.draw)
        #self.image = cairo.ImageSurface.create_from_png('/tmp/arch.png')
        self.image = None

    def draw(self, widget, cr):
        if not self.image:
            return
        img_height = self.image.get_height()
        img_width = self.image.get_width()
        width_ratio = float(48) / float(img_width)
        height_ratio = float(48) / float(img_height)
        scale_xy = min(height_ratio, width_ratio)
        #cr.save()
        cr.scale(scale_xy, scale_xy)
        cr.set_source_surface(self.image)
        cr.paint()
        #cr.restore()




def _cell_data_func_cb(col, cell, model, it, user_data):
    print model.get_value(it, 0)
    cell.props.markup = model.get_value(it, 0)
    #cell.set_property('markup', )


treeview = Gtk.TreeView()
model = Gtk.ListStore(str, bool, bool)
model.append(['<b>epale</b>', True, False])
model.append(['que dice', False, False])
model.append(['hola', False, True])
model.append(['mundo', False, False])

treeview.set_model(model)

tr = CellTestRenderer(treeview.create_pango_layout(''))
column = Gtk.TreeViewColumn('Columna 1')
column.pack_start(tr, True)
#column.set_cell_data_func(tr, _cell_data_func_cb)
column.set_attributes(tr, markup=0, protected=1, verified=2)
treeview.append_column(column)

a = AvatarTest2()

window = Gtk.Window()
window.set_title('Proof of concept')
window.set_size_request(250, 250)
window.set_default_size(300, 480)
window.set_position(Gtk.WindowPosition.CENTER)
window.set_gravity(Gdk.Gravity.STATIC)
window.connect('delete-event', Gtk.main_quit)

window.add(treeview)
#window.add(a)
window.show_all()

#a.set_image('/tmp/arch.png')
if __name__ == "__main__":
    Gtk.main()
