﻿/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2019 Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */
#ifndef UKMEDIAOUTPUTWIDGET_H
#define UKMEDIAOUTPUTWIDGET_H

#include <QWidget>
#include <QLabel>
#include <QComboBox>
#include <QSlider>
#include <QEvent>
#include <QMouseEvent>
#include <QPushButton>
#include <QCoreApplication>
#include <QVBoxLayout>
#include "ukui_custom_style.h"
#include "ukui_list_widget_item.h"
#include "customstyle.h"
#include <QListWidget>
#include <QComboBox>
#include "switchbutton.h"
#include "kswitchbutton.h"
#include <QApplication>

using namespace kdk;

class UkmediaOutputWidget : public QWidget
{
    Q_OBJECT
public:
    explicit UkmediaOutputWidget(QWidget *parent = nullptr);
    ~UkmediaOutputWidget();

    void setOutputVolumeSliderRang(bool status);
    friend class UkmediaMainWidget;
Q_SIGNALS:

public Q_SLOTS:
    void onPaletteChanged();

private:
    QFrame* myLine();
    QFrame *m_pOutputWidget;
    QFrame *m_pMasterVolumeWidget;
    QFrame *m_pChannelBalanceWidget;
    QFrame *m_pVolumeIncreaseWidget;
    QWidget *VolumeIncreaseTipsWidget;

    TitleLabel *m_pOutputLabel;
    QLabel *m_pOutputDeviceLabel;
    QLabel *m_pOpVolumeLabel;
    QLabel *m_pOpVolumePercentLabel;
    QLabel *m_pOpBalanceLabel;
    QLabel *VolumeIncreaseTipsLabel;
    QLabel *m_pLeftBalanceLabel;
    QLabel *m_pRightBalanceLabel;
    QLabel *m_pVolumeIncreaseLabel;

    QComboBox *m_pDeviceSelectBox;
    QFrame *m_pOutputSlectWidget;

    UkuiButtonDrawSvg *m_pOutputIconBtn;
    AudioSlider *m_pOpVolumeSlider;
    UkmediaVolumeSlider *m_pOpBalanceSlider;
    KSwitchButton *m_pVolumeIncreaseButton;

    QVBoxLayout *m_pVlayout;
    QString sliderQss;
};

#endif // UKMEDIAOUTPUTWIDGET_H
