// ==UserScript==
// @include       http://*.mail.yahoo.com/*
// @include       https://*.mail.yahoo.com/*
// @require       utils.js
// ==/UserScript==

// This placeholder gets munged with real data at build time.
var WebappsGettextDict = JSON.parse(unescape(
    "%7B%22GETTEXT%22%3A%22PLACEHOLDER%22%7D"
));

window.Unity = external.getUnityObject(1);

function getComposeMessageNode() {
    return document.getElementById('main-btn-new').firstChild;
}

/**
 * Validates the page for functional tests.
 *
 */
function selfTest() {
    if (!getComposeMessageNode()) {
        return;
    }

    reportTestState('PASS SELF TEST');
}

function isCorrectPage() {
    var i, ids = ['inbox-count', 'Inbox'];

    for (i = 0; i < ids.length; i++) {
        if (!document.getElementById(ids[i])) {
            return false;
        }
    }

    return true;
}

function messagingIndicatorSetup() {
    function composeNewMessage() {
        var compose = getComposeMessageNode();
        launchClickEvent(compose);
    }
    Unity.Launcher.addAction(_("Compose New Message"),
			     wrapCallback(composeNewMessage));

    selfTest();
}

if (isCorrectPage()) {
    Unity.init({ name: 'Yahoo Mail',
                 domain: 'mail.yahoo.com',
                 homepage: 'https://mail.yahoo.com',
                 iconUrl: "icon://unity-webapps-yahoo-mail",
                 onInit: wrapCallback(messagingIndicatorSetup) });

}

