function Test(browser) {
    this._init(browser);
}

Test.prototype = {
    _init: function (browser) {
        this._state = 0;
        this._url = browser.getUrl();
        this._browser = browser;
        browser.open(this._url);
    },

    onLoad: function () {
        if (this._state === 0) {
            setTimeout(function () {
                this._browser.invokeCallback('Unity.MediaPlayer.onNext');
            }.bind(this), 3000);
        } else {
            setTimeout(function () {
                this._browser.finish();
            }.bind(this), 3000);
        }

        this._state++;
    },

    validateCallLog: function (log) {
        assertEquals('Unity.init', log[0].func, 'Unity.init');
        assertEquals('YouTube', log[0].args[0].name, 'YouTube');
        assertEquals('Unity.MediaPlayer.init', log[1].func, 'Unity.MediaPlayer.init');
        assertEquals('Unity.MediaPlayer.setTrack', log[2].func, 'Unity.MediaPlayer.setTrack');
        assertEquals('Faithless - Mass Destruction', log[2].args[0].title, 'Faithless - Mass Destruction');

        var i, hasSecondSong = false;
        for (i = 0; i < log.length; i++) {
            if (log[i].args[0] && log[i].args[0].title === 'Waka Waka (This Time for Africa) (The Official 2010 FIFA ...') {
                hasSecondSong = true;
            }
        }

        assertTrue('hasSecondSong', hasSecondSong);
    },

    scriptName: 'YouTube.user.js'
};
