/**
 * This file is a part of VideoCut package.
 * ---------------------------------------------------------------------- 
 * Copyright (C) 2007-2008 troorl
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ---------------------------------------------------------------------- 
 *
 * @author troorl <troorl@gmail.com>
 */

#include "backends/TXine.h"
//#include "backends/TFfmpeg.h"
#include "TOptions/TConfigdialog.h"
#include "TOptions/TPages.h"
#include "TOptions/TUserSettings.h"
#include "TPreviewPanel/TPreviewPanel.h"
#include "TListPanel/TListPanel.h"
#include "TViewFrame/TViewFrame.h"
#include "TFrameStruct.h"
#include "const.h"
#include "TOptions/TColorChoser.h"
#include "TAboutWindow.h"
#include "TProgress.h"
//#include "TVideo/TVideo.h"

/*
	Main window class
*/
class TMainWindow : public QMainWindow
{
    Q_OBJECT 

public:

	TMainWindow(QWidget *parent = 0);
	~TMainWindow();
	
	void GUI();
	
    void menuInit();
    void perfectFile(bool many);
    void deleteAllItems();
    void makePreview(bool many);
	void drawPreview();
    QString timeToString(int currPos);
    void readSettings();
	void openMain();
	void openManyMain();

private slots:
    void S_showCurrImage(int);
    void S_SaveCurrImage();
	void S_SaveAllImages();
	void S_Exit();
    void S_DelFrame();    
    void S_OpenFile();
	void S_OpenFiles();
	void S_SaveScene();
	void S_PrintScene();
    void S_Options();
    void S_ApplyChanges();
	void S_ChangeStyle(int);
	void S_ChangeTimePos(int);
	void S_ChangeSize(int);
	void S_ChangeOffset(int);
	void S_ChangeSpace(int);
	void S_ChangeColor(QColor &);
	//void S_EnablePlayer();
	void S_ChangeSizeToolbar(bool);
	void S_AboutQt();
	void S_About();
	
private:
	QTranslator trans;
	QString mainTitle;
	
    QList<frameStruct*> *frames;

	// GUI
	TAboutWindow *aboutWindow;
	
	QDockWidget *dock;
	//TVideo *player;
    TPreviewPanel *previewPanel1; // finaly previews
    TListPanel *listPanel1; // list of previews in the bottom of the window
	QListWidget *listView;
	TViewFrame *viewFrame1; // view current frame
	QToolBar *toolbar;
	
	QWidget *toolBox;
	QComboBox *styleBox;
	QComboBox *timePosBox;
	QSpinBox *sizeBox;
	QSpinBox *offsetBox;
	QSpinBox *spaceBox;
	TColorChoser *colorBox;
	
	QTabWidget *tabWidget;
	QWidget *tab1;
	QWidget *tab2;
	QMenuBar *menubar;
	QMenu *menuFile;
	QMenu *menuFrame;
	QMenu *menuOptions;
		QMenu *menuToolbar;
	QMenu *menuHelp;
	QStatusBar *statusbar;

	QString tempPath;
	
    QString path;
	QStringList paths;
	
	QFileInfo fileInfo;
	
    QAction *openAct, *openManyAct, *closeAct;
	QAction *saveSceneAct;
	QAction *saveMultiAct;
	QAction *printAct;
    QAction *delFrameAct;
	QAction *saveFrameAct;
    QAction *optionsAct;
	QAction *aboutAct;
	QAction *aboutQtAct;

	QActionGroup *sizeGroup;
	QAction *size16;
	QAction *size24;
	QAction *size32;
	QAction *size48;

    TConfigDialog *optionsDialog;

    TUserSettings *settings;
	
	TProgress *prog;

    bool isOpen;
	
	// Xine backend
	TXine *backend;
	//TFfmpeg *backend;
	
	// file properties
    int length;              // length of file
    QString  videocodec, audiocodec;
};
