/*
 * Decompiled with CFR 0.152.
 */
package vncviewer;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import vncviewer.AboutDialog;
import vncviewer.Dialog;
import vncviewer.OptionsDialog;

class ServerDialog
extends Dialog {
    TextField server;
    Choice encryption;
    Button aboutButton;
    Button optionsButton;
    Button okButton;
    Button cancelButton;
    OptionsDialog options;
    AboutDialog about;

    public ServerDialog(OptionsDialog options_, AboutDialog about_, String defaultServerName) {
        super(true);
        this.setTitle("VNC Viewer : Connection Details");
        this.options = options_;
        this.about = about_;
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        this.addComponent(new Label("Server:", 2), 0, 0, 1, 1, 0, new Insets(4, 0, 0, 0));
        this.server = new TextField(15);
        this.addComponent(this.server, 1, 0, 2, 1, 0, new Insets(4, 0, 0, 0));
        this.addComponent(new Label("Encryption:", 2), 0, 1, 1, 1, 0, new Insets(2, 0, 0, 0));
        this.encryption = new Choice();
        this.addComponent(this.encryption, 1, 1, 2, 1, 0, new Insets(2, 0, 0, 0));
        this.optionsButton = new Button("Options...");
        this.addComponent(this.optionsButton, 1, 2, 1, 1, 0, new Insets(8, 4, 4, 4));
        this.aboutButton = new Button("About...");
        this.addComponent(this.aboutButton, 0, 2, 1, 1, 35, new Insets(8, 4, 4, 4));
        this.okButton = new Button("OK");
        this.addComponent(this.okButton, 2, 2, 1, 1, 40, new Insets(8, 4, 4, 4));
        this.cancelButton = new Button("Cancel");
        this.addComponent(this.cancelButton, 3, 2, 1, 1, 30, new Insets(8, 4, 4, 4));
        if (defaultServerName != null) {
            this.server.setText(defaultServerName);
        }
        this.encryption.add("Not supported");
        this.encryption.select(0);
        this.encryption.setEnabled(false);
        this.pack();
    }

    protected void addComponent(Component comp, int x, int y, int w, int h, int extra, Insets padding) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.fill = 2;
        gbc.insets = padding;
        gbc.ipadx = extra;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(comp, gbc);
    }

    public synchronized boolean action(Event event, Object arg) {
        if (event.target == this.okButton || event.target == this.server) {
            this.ok = true;
            this.endDialog();
        } else if (event.target == this.cancelButton) {
            this.ok = false;
            this.endDialog();
        } else if (event.target == this.optionsButton) {
            this.options.showDialog();
        } else if (event.target == this.aboutButton) {
            this.about.showDialog();
        }
        return true;
    }
}

