/*---------------------------------------------------------------------------*\

    FILE....: hostfiletone.cpp
    TYPE....: C++ program
    AUTHOR..: Ben Kramer
    DATE....: 31/03/2006

    Test program for detecting tones from a file, using the Host DSP based tone
    detector. 

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2006 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include "mess.h"
#include "comm.h"
#include "config.h"
#include "dspfifo.h"
#include "timer.h"
#include "timer.h"
#include "wobbly.h"
#include "vpbapi.h"
#include "mapdev.h"
#include "translate.h"
#include "verbose.h"

extern "C" {
#include "toned.h"
}

#include "hostfiletone.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>


#define NBUF 160
#define SIZEOFHEADERINWORDS     15
#define STARTNSTATES            12
#define SIZEOFVPB_STRANINWORDS  4


static void toned_callback(word mess[],void *board);
void settonedmess(word *mess, VPB_DETECT *d);
void settoned_logging(TD *toned, int id);

int main(int argc, char * argv[])
{
	WFILE *file  = NULL;
	TD    *toned;
	int    board = 0;
	int    ret;
	int    count = 0;

	short buf[NBUF];

	word mess[COMM_MAX_MESSPCDSP];

	if (argc != 2) {
		printf("usage: %s <wave file>\n",argv[0]);
		exit(-1);
	}
	verbose(1);
	toned_open(&toned,0,&toned_callback,(void*)&board);

	settonedmess(mess, &toned_dial);
	toned_add_tone(toned,mess);

	settonedmess(mess, &toned_ringback_aust);
	toned_add_tone(toned,mess);

	settonedmess(mess, &toned_ringback_308);
	toned_add_tone(toned,mess);

	settonedmess(mess, &toned_busy_308);
	toned_add_tone(toned,mess);

	settonedmess(mess, &toned_busy_aust);
	toned_add_tone(toned,mess);

	settonedmess(mess, &toned_grunt);
	toned_add_tone(toned,mess);

	settonedmess(mess, &toned_ringback_us);
	toned_add_tone(toned,mess);

	settonedmess(mess, &toned_busy_us);
	toned_add_tone(toned,mess);

	settonedmess(mess, &toned_fax);
	toned_add_tone(toned,mess);

	settonedmess(mess, &user_tone);
	toned_add_tone(toned,mess);


	settoned_logging(toned, 0);

	vpb_wave_open_read(&file, argv[1]);
	if (file == NULL){
		printf("Failed to open file %s\n", argv[1]);
		exit(-1);
	}
	do {
		ret = vpb_wave_read(file,(char*)buf,sizeof(short)*NBUF);
		toned_analyse(toned, (short*)&buf, NBUF);
		count++;
	} while(ret == sizeof(short)*NBUF);

	vpb_wave_close_read(file);
	toned_close(toned);
	mprintf("processed %d frames of %d samples\n",count,NBUF);
	exit(0);
}

void toned_callback(word mess[],void *board)
{
	if (mess[1] == DSP_TONED){
		printf("Got Tone[%d] from[%d] on [%d]\n",mess[3],mess[2],*(int *)board);
	}
	else if (mess[1] == DSP_TONED_LOG){
		printf("Got logging\n");
	}
	else {
		printf("Got unknown call back message\n");
	}
}

void settonedmess(word *mess, VPB_DETECT *d)
{
	mess[0] = (word)(SIZEOFHEADERINWORDS+d->nstates* SIZEOFVPB_STRANINWORDS);
	mess[1] = (word)PC_TONED_ST;
	mess[2] = 0;
	memcpy(&mess[3], d, sizeof(VPB_DETECT));
}

void settoned_logging(TD *toned, int ToneID)
{
	word mess[COMM_MAX_MESSPCDSP];
	mess[0] = PC_LTONED_DEBUG;
	mess[1] = PC_TONED_DEBUG;
	mess[2] = 0; // Tone detector ID
	mess[3] = ToneID; // Tone id
	mess[4] = (word)500;
	toned_start_logging(toned, mess);
}
