/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util.frustum;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;
import org.j3d.util.frustum.Canvas3DFrustum;

public abstract class ViewFrustum {
    public static final int IN = 1;
    public static final int OUT = 2;
    public static final int CLIPPED = 4;
    private Point4d[] frustumPoints;
    private Canvas3DFrustum[] frustums;
    protected final int numCanvases;
    private Matrix4d inverseProjection;
    private Vector3d tVec1;
    private Vector3d tVec2;
    private Vector3d tVec3;
    private Matrix4d tMatrix;
    private Point3d tmpP1;
    private Point3d tmpP2;
    private Point3d tmpP3;

    public ViewFrustum(int n) {
        this.numCanvases = n;
        this.tMatrix = new Matrix4d();
        this.tVec1 = new Vector3d();
        this.tVec2 = new Vector3d();
        this.tVec3 = new Vector3d();
        this.tmpP1 = new Point3d();
        this.tmpP2 = new Point3d();
        this.tmpP3 = new Point3d();
        this.inverseProjection = new Matrix4d();
        this.frustumPoints = new Point4d[8];
        this.frustumPoints[0] = new Point4d();
        this.frustumPoints[1] = new Point4d();
        this.frustumPoints[2] = new Point4d();
        this.frustumPoints[3] = new Point4d();
        this.frustumPoints[4] = new Point4d();
        this.frustumPoints[5] = new Point4d();
        this.frustumPoints[6] = new Point4d();
        this.frustumPoints[7] = new Point4d();
        this.frustums = new Canvas3DFrustum[n];
        for (int i = 0; i < n; ++i) {
            this.frustums[i] = new Canvas3DFrustum();
        }
    }

    public void viewingPlatformMoved() {
        for (int i = 0; i < this.numCanvases; ++i) {
            this.computeFrustumPlanes(i);
        }
    }

    public void manualPlatformMove(Matrix4d matrix4d) {
        matrix4d.transform(this.frustumPoints[0]);
        matrix4d.transform(this.frustumPoints[1]);
        matrix4d.transform(this.frustumPoints[2]);
        matrix4d.transform(this.frustumPoints[3]);
        matrix4d.transform(this.frustumPoints[4]);
        matrix4d.transform(this.frustumPoints[5]);
        matrix4d.transform(this.frustumPoints[6]);
        matrix4d.transform(this.frustumPoints[7]);
        for (int i = 0; i < this.numCanvases; ++i) {
            this.updatePlanes(i);
        }
    }

    public int isTriangleInFrustum(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.tmpP1.set(f, f2, f3);
        this.tmpP2.set(f4, f5, f6);
        this.tmpP3.set(f7, f8, f9);
        return this.isTriangleInFrustum(this.tmpP1, this.tmpP2, this.tmpP3);
    }

    public int isTriangleInFrustum(Point3d point3d, Point3d point3d2, Point3d point3d3) {
        for (int i = 0; i < this.frustums.length; ++i) {
            if (this.frustums[i].isTriangleInFrustum(point3d, point3d2, point3d3) == 2) continue;
            return 1;
        }
        return 2;
    }

    public int isPointInFrustum(Point3d point3d) {
        for (int i = 0; i < this.frustums.length; ++i) {
            if (!this.frustums[i].isPointInFrustum(point3d)) continue;
            return 1;
        }
        return 2;
    }

    public void getBounds(Point3d point3d, Point3d point3d2) {
        point3d.x = this.frustumPoints[0].x;
        point3d.y = this.frustumPoints[0].y;
        point3d.z = this.frustumPoints[0].z;
        point3d2.x = this.frustumPoints[0].x;
        point3d2.y = this.frustumPoints[0].y;
        point3d2.z = this.frustumPoints[0].z;
        for (int i = 1; i < 7; ++i) {
            double d = this.frustumPoints[i].x;
            double d2 = this.frustumPoints[i].y;
            double d3 = this.frustumPoints[i].z;
            point3d.x = point3d.x < d ? point3d.x : d;
            point3d.y = point3d.y < d2 ? point3d.y : d2;
            point3d.z = point3d.z < d3 ? point3d.z : d3;
            point3d2.x = point3d2.x > d ? point3d2.x : d;
            point3d2.y = point3d2.y > d2 ? point3d2.y : d2;
            point3d2.z = point3d2.z > d3 ? point3d2.z : d3;
        }
    }

    protected abstract void getInverseWorldProjection(int var1, Matrix4d var2);

    private void computeFrustumPlanes(int n) {
        this.frustumPoints[0].set(-1.0, -1.0, 1.0, 1.0);
        this.frustumPoints[1].set(-1.0, 1.0, 1.0, 1.0);
        this.frustumPoints[2].set(1.0, 1.0, 1.0, 1.0);
        this.frustumPoints[3].set(1.0, -1.0, 1.0, 1.0);
        this.frustumPoints[4].set(-1.0, -1.0, -1.0, 1.0);
        this.frustumPoints[5].set(-1.0, 1.0, -1.0, 1.0);
        this.frustumPoints[6].set(1.0, 1.0, -1.0, 1.0);
        this.frustumPoints[7].set(1.0, -1.0, -1.0, 1.0);
        this.getInverseWorldProjection(n, this.inverseProjection);
        for (int i = 0; i < this.frustumPoints.length; ++i) {
            this.inverseProjection.transform(this.frustumPoints[i]);
            double d = 1.0 / this.frustumPoints[i].w;
            this.frustumPoints[i].x *= d;
            this.frustumPoints[i].y *= d;
            this.frustumPoints[i].z *= d;
        }
        this.updatePlanes(n);
    }

    private void updatePlanes(int n) {
        this.computePlaneEq(this.frustumPoints[0], this.frustumPoints[4], this.frustumPoints[5], this.frustumPoints[1], this.frustums[n].frustumPlanes[0]);
        this.computePlaneEq(this.frustumPoints[3], this.frustumPoints[2], this.frustumPoints[6], this.frustumPoints[7], this.frustums[n].frustumPlanes[1]);
        this.computePlaneEq(this.frustumPoints[1], this.frustumPoints[5], this.frustumPoints[6], this.frustumPoints[2], this.frustums[n].frustumPlanes[2]);
        this.computePlaneEq(this.frustumPoints[0], this.frustumPoints[3], this.frustumPoints[7], this.frustumPoints[4], this.frustums[n].frustumPlanes[3]);
        this.computePlaneEq(this.frustumPoints[0], this.frustumPoints[1], this.frustumPoints[2], this.frustumPoints[3], this.frustums[n].frustumPlanes[4]);
        this.computePlaneEq(this.frustumPoints[4], this.frustumPoints[7], this.frustumPoints[6], this.frustumPoints[5], this.frustums[n].frustumPlanes[5]);
    }

    private void computePlaneEq(Point4d point4d, Point4d point4d2, Point4d point4d3, Point4d point4d4, Vector4d vector4d) {
        this.tVec1.x = point4d3.x - point4d.x;
        this.tVec1.y = point4d3.y - point4d.y;
        this.tVec1.z = point4d3.z - point4d.z;
        this.tVec2.x = point4d2.x - point4d.x;
        this.tVec2.y = point4d2.y - point4d.y;
        this.tVec2.z = point4d2.z - point4d.z;
        this.tVec3.cross(this.tVec2, this.tVec1);
        this.tVec3.normalize();
        vector4d.x = this.tVec3.x;
        vector4d.y = this.tVec3.y;
        vector4d.z = this.tVec3.z;
        vector4d.w = -(vector4d.x * point4d.x + vector4d.y * point4d.y + vector4d.z * point4d.z);
    }
}

