/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.functions;

import edu.hws.jcm.awt.Computable;
import edu.hws.jcm.draw.CoordinateRect;
import edu.hws.jcm.draw.DisplayCanvas;
import edu.hws.jcm.draw.Drawable;
import edu.hws.jcm.functions.TableFunction;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class TableFunctionGraph
extends Drawable
implements MouseListener,
MouseMotionListener {
    private TableFunction function;
    private boolean showPoints;
    private boolean interactive;
    private Computable onDrag;
    private Computable onFinishDrag;
    private Color color;
    private int dragPoint = -1;
    private int startX;
    private int startY;
    private int prevY;
    private boolean moved;

    public TableFunctionGraph() {
        this(null);
    }

    public TableFunctionGraph(TableFunction tableFunction) {
        this.function = tableFunction;
        this.color = Color.magenta;
        this.showPoints = true;
    }

    public void setFunction(TableFunction tableFunction) {
        this.function = tableFunction;
        this.needsRedraw();
    }

    public TableFunction getFunction() {
        return this.function;
    }

    public void setOnDrag(Computable computable) {
        this.onDrag = computable;
    }

    public Computable getOnDrag() {
        return this.onDrag;
    }

    public void setOnFinishDrag(Computable computable) {
        this.onFinishDrag = computable;
    }

    public Computable getOnFinishDrag() {
        return this.onFinishDrag;
    }

    public void setInteractive(boolean bl) {
        if (this.interactive == bl) {
            return;
        }
        if (this.interactive && this.canvas != null) {
            this.canvas.removeMouseListener(this);
            this.canvas.removeMouseMotionListener(this);
        }
        this.interactive = bl;
        if (this.interactive && this.canvas != null) {
            this.canvas.addMouseListener(this);
            this.canvas.addMouseMotionListener(this);
        }
    }

    public boolean getInteractive() {
        return this.interactive;
    }

    public void setShowPoints(boolean bl) {
        this.showPoints = bl;
        this.needsRedraw();
    }

    public boolean getShowPoints() {
        return this.showPoints;
    }

    public void setColor(Color color) {
        if (color != null) {
            this.color = color;
            this.needsRedraw();
        }
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    protected void setOwnerData(DisplayCanvas displayCanvas, CoordinateRect coordinateRect) {
        if (this.interactive && this.canvas != null) {
            displayCanvas.removeMouseListener(this);
            displayCanvas.removeMouseMotionListener(this);
        }
        super.setOwnerData(displayCanvas, coordinateRect);
        if (this.interactive && this.canvas != null) {
            displayCanvas.addMouseListener(this);
            displayCanvas.addMouseMotionListener(this);
        }
    }

    public void setFunctionStyle(int n) {
        if (this.function != null && this.function.getStyle() != n) {
            this.function.setStyle(n);
            this.needsRedraw();
        }
    }

    @Override
    public void draw(Graphics graphics, boolean bl) {
        int n;
        int n2;
        double d;
        double d2;
        int n3;
        int n4;
        if (this.function == null || this.coords == null) {
            return;
        }
        int n5 = this.function.getPointCount();
        if (n5 == 0) {
            return;
        }
        double d3 = this.coords.pixelToX(this.coords.getLeft());
        double d4 = this.coords.pixelToX(this.coords.getLeft() + this.coords.getWidth());
        if (this.function.getX(0) > d4 || this.function.getX(n5 - 1) < d3) {
            return;
        }
        for (n4 = 0; n4 < n5 - 1 && this.function.getX(n4 + 1) <= d3; ++n4) {
        }
        for (n3 = n5 - 1; n3 > 1 && this.function.getX(n3 - 1) >= d4; --n3) {
        }
        graphics.setColor(this.color);
        switch (this.function.getStyle()) {
            case 0: {
                int n6;
                double d5;
                double d6;
                if (n3 <= n4) break;
                d2 = this.function.getX(n4);
                d = this.function.getVal(d2);
                n2 = this.coords.xToPixel(d2);
                n = this.coords.yToPixel(d);
                double d7 = d4;
                if (this.function.getX(n3) < d7) {
                    d7 = this.function.getX(n3);
                }
                this.coords.xToPixel(this.function.getX(n5 - 1));
                int n7 = n2;
                while (d2 < d7) {
                    d6 = this.coords.pixelToX(n7 += 3);
                    if (d6 > d7) {
                        d6 = d7;
                    }
                    d5 = this.function.getVal(d6);
                    n6 = this.coords.yToPixel(d5);
                    graphics.drawLine(n2, n, n7, n6);
                    d2 = d6;
                    n2 = n7;
                    n = n6;
                }
                break;
            }
            case 1: {
                int n6;
                double d5;
                double d6;
                int n7;
                d2 = this.function.getX(n4);
                n2 = this.coords.xToPixel(d2);
                d = this.function.getY(n4);
                n = this.coords.yToPixel(d);
                for (int i = n4 + 1; i <= n3; ++i) {
                    d6 = this.function.getX(i);
                    n7 = this.coords.xToPixel(d6);
                    d5 = this.function.getY(i);
                    n6 = this.coords.yToPixel(d5);
                    graphics.drawLine(n2, n, n7, n6);
                    n2 = n7;
                    n = n6;
                }
                break;
            }
            case 2: {
                double d6;
                int n7;
                d2 = this.function.getX(n4);
                n2 = this.coords.xToPixel(d2);
                for (int i = n4; i <= n3; ++i) {
                    if (i < n3) {
                        double d8 = this.function.getX(i + 1);
                        d6 = (d2 + d8) / 2.0;
                        d2 = d8;
                    } else {
                        d6 = d2;
                    }
                    n7 = this.coords.xToPixel(d6);
                    d = this.function.getY(i);
                    n = this.coords.yToPixel(d);
                    graphics.drawLine(n2, n, n7, n);
                    n2 = n7;
                }
                break;
            }
            case 3: {
                double d6;
                int n7;
                d2 = this.function.getX(n4);
                n2 = this.coords.xToPixel(d2);
                for (int i = n4 + 1; i <= n3; ++i) {
                    d6 = this.function.getX(i);
                    n7 = this.coords.xToPixel(d6);
                    d = this.function.getY(i - 1);
                    n = this.coords.yToPixel(d);
                    graphics.drawLine(n2, n, n7, n);
                    n2 = n7;
                }
                break;
            }
            case 4: {
                double d6;
                int n7;
                d2 = this.function.getX(n4);
                n2 = this.coords.xToPixel(d2);
                for (int i = n4 + 1; i <= n3; ++i) {
                    d6 = this.function.getX(i);
                    n7 = this.coords.xToPixel(d6);
                    d = this.function.getY(i);
                    n = this.coords.yToPixel(d);
                    graphics.drawLine(n2, n, n7, n);
                    n2 = n7;
                }
                break;
            }
        }
        if (!this.showPoints) {
            return;
        }
        for (int i = n4; i <= n3; ++i) {
            d2 = this.function.getX(i);
            d = this.function.getY(i);
            n2 = this.coords.xToPixel(d2);
            n = this.coords.yToPixel(d);
            graphics.fillOval(n2 - 2, n - 2, 5, 5);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.dragPoint = -1;
        if (this.function == null || !this.getVisible() || this.canvas == null || this.coords == null || mouseEvent.isConsumed()) {
            return;
        }
        if (mouseEvent.isShiftDown() || mouseEvent.isMetaDown() || mouseEvent.isControlDown() || mouseEvent.isAltDown()) {
            return;
        }
        this.moved = false;
        int n = this.function.getPointCount();
        for (int i = 0; i < n; ++i) {
            int n2 = this.coords.xToPixel(this.function.getX(i));
            int n3 = this.coords.yToPixel(this.function.getY(i));
            if (mouseEvent.getX() < n2 - 3 || mouseEvent.getX() > n2 + 3 || mouseEvent.getY() < n3 - 3 || mouseEvent.getY() > n3 + 3) continue;
            this.startX = mouseEvent.getX();
            this.prevY = this.startY = mouseEvent.getY();
            this.dragPoint = i;
            mouseEvent.consume();
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.dragPoint == -1) {
            return;
        }
        mouseEvent.consume();
        if (!this.moved) {
            this.dragPoint = -1;
            return;
        }
        this.mouseDragged(mouseEvent);
        this.dragPoint = -1;
        if (this.onFinishDrag != null) {
            this.onFinishDrag.compute();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.dragPoint == -1 || this.prevY == mouseEvent.getY()) {
            return;
        }
        mouseEvent.consume();
        if (!this.moved && Math.abs(mouseEvent.getY() - this.startY) < 3) {
            return;
        }
        this.moved = true;
        int n = mouseEvent.getY();
        if (n < this.coords.getTop() + 4) {
            n = this.coords.getTop() + 4;
        } else if (n > this.coords.getTop() + this.coords.getHeight() - 4) {
            n = this.coords.getTop() + this.coords.getHeight() - 4;
        }
        if (Math.abs(mouseEvent.getX() - this.startX) > 72) {
            n = this.startY;
        }
        if (n == this.prevY) {
            return;
        }
        this.prevY = n;
        this.function.setY(this.dragPoint, this.coords.pixelToY(this.prevY));
        this.needsRedraw();
        if (this.onDrag != null) {
            this.onDrag.compute();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

