/*
 *  This file is part of X-File Manager XFM
 *  ----------------------------------------------------------------------
 FmAwPopup.c

 (c) Simon Marlow 1990-92
 (c) Albert Graef 1994

 modified 2005,2006,2007 by Bernhard R. Link (see Changelog)

 Functions & data for creating the popup 'install application' window
 *  ----------------------------------------------------------------------
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <xfmconfig.h>

#include <string.h>
#include <assert.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xmu/Drawing.h>

#include "global.h"

#include "Am.h"

/*---------------------------------------------------------------------------
  STATIC DATA
---------------------------------------------------------------------------*/

static struct PopupDialog *install_app_popup, *install_group_popup;

static int app_number;

/*---------------------------------------------------------------------------
  PRIVATE FUNCTIONS
---------------------------------------------------------------------------*/

static PDCallbackProc installAppOkCb, installAppCancelCb,
installGroupOkCb, installGroupCancelCb;

static void installAppOkCb(UNUSED(Widget w), struct PopupDialog *p,
                           UNUSED(void *call_data))
{
  popdownPopup(p);

  if (aw.readonly)
	  return;
  if (app_number != -1)
    replaceApplication(aw.apps+app_number,
		    getPopupAnswer(p, 0), getPopupAnswer(p, 1),
		    getPopupAnswer(p, 2),
		    getPopupAnswer(p, 3), getPopupAnswer(p, 4));
  else
    installApplication( getPopupAnswer(p, 0), getPopupAnswer(p, 1),
		    getPopupAnswer(p, 2),
		    getPopupAnswer(p, 3), getPopupAnswer(p, 4));

  updateApplicationDisplay();
  writeApplicationData();
}

/*---------------------------------------------------------------------------*/

static void installAppCancelCb(UNUSED(Widget w), struct PopupDialog *p,
			       UNUSED(void *call_data))
{
  popdownPopup(p);
}

/*---------------------------------------------------------------------------*/

static void installGroupOkCb(UNUSED(Widget w), struct PopupDialog *p,
                             UNUSED(void *call_data))
{
  char *appfile;
  popdownPopup(p);

  if (aw.readonly)
	  return;
  appfile = suffixConcat(getPopupAnswer(p, 0),"xfm");
  installApplication(getPopupAnswer(p, 0), appfile, getPopupAnswer(p, 1),
		  "LOAD", "");
  XtFree(appfile);

  updateApplicationDisplay();
  writeApplicationData();
}

/*---------------------------------------------------------------------------*/

static void installGroupCancelCb(UNUSED(Widget w), struct PopupDialog *p,
                                 UNUSED(void *call_data))
{
  popdownPopup(p);
}

/*---------------------------------------------------------------------------
  Question and button data
---------------------------------------------------------------------------*/

static const QuestionRec install_app_questions[5] = {
  { "Name:", MAXAPPSTRINGLEN },
  { "Directory:", MAXAPPSTRINGLEN },
  { "Icon:", MAXAPPSTRINGLEN },
  { "Push action:", MAXAPPSTRINGLEN },
  { "Drop action:", MAXAPPSTRINGLEN }
};

static const PDButtonRec install_app_buttons[] = {
  { "install", "Install", installAppOkCb },
  { "cancel", "Cancel", installAppCancelCb }
};

static const QuestionRec install_group_questions[2] = {
  { "Name:", MAXAPPSTRINGLEN },
  { "Icon:", MAXAPPSTRINGLEN }
};

static const PDButtonRec install_group_buttons[] = {
  { "install", "Install", installGroupOkCb },
  { "cancel", "Cancel", installGroupCancelCb }
};

/*---------------------------------------------------------------------------
  PUBLIC FUNCTIONS
---------------------------------------------------------------------------*/

void createInstallPopups(void)
{
    createPopupQuestions(&install_app_popup, aw.shell,
		         "install app",
			 "Install Application",
			 None,
			 install_app_questions,
			 XtNumber(install_app_questions),
			 install_app_buttons,
			 XtNumber(install_app_buttons),
			 XtNumber(install_app_buttons)-1);
    createPopupQuestions(&install_group_popup, aw.shell,
		         "install group",
			 "Install Group",
			 None,
			 install_group_questions,
			 XtNumber(install_group_questions),
			 install_group_buttons,
			 XtNumber(install_group_buttons),
			 XtNumber(install_group_buttons)-1);
}

/*----------------------------------------------------------------------------*/

void installNewAppPopup(void)
{
  Cardinal i;

  for (i=0; i < XtNumber(install_app_questions); i++) {
	  setPopupData(install_app_popup, i, "");
  }
  app_number = -1;
  popupPopupByCursor(install_app_popup, NULL);
}

/*----------------------------------------------------------------------------*/

void installExistingAppPopup(void)
{
  Cardinal i;

  if (aw.readonly)
	  return;

  for (i=0; i<aw.n_apps; i++)
    if (aw.apps[i].selected) {
	app_number = i;
	setPopupData(install_app_popup, 0, aw.apps[i].name);
	setPopupData(install_app_popup, 1, aw.apps[i].directory);
	setPopupData(install_app_popup, 2, aw.apps[i].icon);
	setPopupData(install_app_popup, 3, aw.apps[i].push_action);
	setPopupData(install_app_popup, 4, aw.apps[i].drop_action);
	break;
    }

  popupPopupByCursor(install_app_popup, (void*)i);
}

/*----------------------------------------------------------------------------*/

void installGroupPopup(void)
{
  Cardinal i;

  if (aw.readonly)
	  return;

  for (i=0; i < XtNumber(install_group_questions); i++) {
	  setPopupData(install_group_popup, i, "");
  }

  popupPopupByCursor(install_group_popup, NULL);
}
